/*
 * Decompiled with CFR 0.152.
 */
public class WorldType {
    public int id;
    public String name;
    public String languageKey;
    public xa worldProvider = null;
    public Season[] seasons;
    public Weather defaultWeather = Weather.weatherClear;
    public boolean enabled = true;
    public static WorldType[] worldTypes = new WorldType[13];
    public static WorldType overworld = new WorldType(0, "default").setLanguageKey("worldType.overworld").setWorldProvider(new WorldProviderOverworld()).setDefaultWeather(Weather.weatherClear).setSeasonList(new Season[]{Season.surfaceSpring, Season.surfaceSummer, Season.surfaceFall, Season.surfaceWinter});
    public static WorldType overworldIslands = new WorldType(1, "islands").setLanguageKey("worldType.islands").setWorldProvider(new WorldProviderOverworldIslands()).setDefaultWeather(Weather.weatherClear).setSeasonList(new Season[]{Season.surfaceSpring, Season.surfaceSummer, Season.surfaceFall, Season.surfaceWinter});
    public static WorldType overworldWinter = new WorldType(2, "winter").setLanguageKey("worldType.winter").setWorldProvider(new WorldProviderOverworld()).setDefaultWeather(Weather.weatherSnow).setSeasonList(new Season[]{Season.surfaceWinter});
    public static WorldType overworldFlat = new WorldType(3, "flat").setLanguageKey("worldType.flat").setWorldProvider(new WorldProviderFlat()).setDefaultWeather(Weather.weatherClear);
    public static WorldType overworldHell = new WorldType(4, "hell").setLanguageKey("worldType.hell").setWorldProvider(new WorldProviderGeneric(ChunkProviderOverworldHell.class)).setDefaultWeather(Weather.weatherHellClear).setSeasonList(new Season[]{Season.surfaceHell});
    public static WorldType overworldWoods = new WorldType(5, "woods").setLanguageKey("worldType.woods").setWorldProvider(new WorldProviderOverworldWoods()).setDefaultWeather(Weather.weatherWoodsClear).setSeasonList(new Season[]{Season.surfaceSpring, Season.surfaceSummer, Season.surfaceFall, Season.surfaceWinter});
    public static WorldType overworldParadise = new WorldType(6, "paradise").setLanguageKey("worldType.paradise").setWorldProvider(new WorldProviderOverworldParadise()).setSeasonList(new Season[]{Season.surfaceSpring});
    public static WorldType overworldRetro = new WorldType(7, "retro").setLanguageKey("worldType.retro").setWorldProvider(new WorldProviderGeneric(ChunkProviderRetro.class));
    public static WorldType overworldRuins = new WorldType(8, null).setLanguageKey("worldType.ruins");
    public static WorldType overworldDungeonCrawler = new WorldType(9, null).setLanguageKey("worldType.dungeons");
    public static WorldType overworldDeeper = new WorldType(10, "extended").setLanguageKey("worldType.deeper").setWorldProvider(new WorldProviderOverworldDeeper()).setDefaultWeather(Weather.weatherClear).setSeasonList(new Season[]{Season.surfaceSpring, Season.surfaceSummer, Season.surfaceFall, Season.surfaceWinter});
    public static WorldType nether = new WorldType(11, null).setWorldProvider(new wd());
    public static WorldType paradise = new WorldType(12, null).setWorldProvider(new ay()).setSeasonList(new Season[]{Season.surfaceSpring});

    public WorldType(int id2, String name) {
        this.id = id2;
        this.name = name;
        WorldType.worldTypes[id2] = this;
    }

    public static WorldType getByName(String name) {
        for (int i2 = 0; i2 < worldTypes.length; ++i2) {
            if (worldTypes[i2] == null || WorldType.worldTypes[i2].worldProvider == null || WorldType.worldTypes[i2].name == null || !WorldType.worldTypes[i2].name.equals(name)) continue;
            return worldTypes[i2];
        }
        return null;
    }

    public WorldType setLanguageKey(String languageKey) {
        this.languageKey = languageKey;
        return this;
    }

    public WorldType setWorldProvider(xa worldProvider) {
        this.worldProvider = worldProvider;
        return this;
    }

    public WorldType setSeasonList(Season[] seasons) {
        this.seasons = seasons;
        return this;
    }

    public WorldType setDefaultWeather(Weather weather) {
        this.defaultWeather = weather;
        return this;
    }
}

