/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MinecraftServer
implements Runnable,
ICommandListener {
    public static Logger logger = Logger.getLogger("Minecraft");
    public static final String VERSION = "1.7.6.1";
    public static HashMap field_6037_b = new HashMap();
    public NetworkListenThread networkServer;
    public PropertyManager propertyManagerObj;
    public WorldServer[] worldMngr;
    public ServerConfigurationManager configManager;
    private ConsoleCommandHandler commandHandler;
    private boolean serverRunning = true;
    public boolean serverStopped = false;
    int deathTime = 0;
    public String currentTask;
    public int percentDone;
    private List field_9010_p = new ArrayList();
    private List commands = Collections.synchronizedList(new ArrayList());
    public EntityTracker[] entityTracker = new EntityTracker[Dimension.dimensionList.length];
    public boolean onlineMode;
    public boolean spawnPeacefulMobs;
    public boolean pvpOn;
    public boolean allowFlight;
    public int spawnProtectionRange;

    public MinecraftServer() {
        new ThreadSleepForeverServer(this);
    }

    private boolean startServer() throws UnknownHostException {
        this.commandHandler = new ConsoleCommandHandler(this);
        ThreadCommandReader threadcommandreader = new ThreadCommandReader(this);
        threadcommandreader.setDaemon(true);
        threadcommandreader.start();
        ConsoleLogManager.init();
        logger.info("Starting minecraft server version Beta 1.7.6.1");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            logger.warning("**** NOT ENOUGH RAM!");
            logger.warning("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        logger.info("Loading properties");
        this.propertyManagerObj = new PropertyManager(new File("server.properties"));
        String s2 = this.propertyManagerObj.getStringProperty("server-ip", "");
        this.onlineMode = this.propertyManagerObj.getBooleanProperty("online-mode", true);
        this.spawnPeacefulMobs = this.propertyManagerObj.getBooleanProperty("spawn-animals", true);
        this.pvpOn = this.propertyManagerObj.getBooleanProperty("pvp", true);
        this.allowFlight = this.propertyManagerObj.getBooleanProperty("allow-flight", false);
        WorldType worldtype = WorldType.getByName(this.propertyManagerObj.getStringProperty("world-type", "extended"));
        this.spawnProtectionRange = this.propertyManagerObj.getIntProperty("spawn-protection", 0);
        if (worldtype != null) {
            Dimension.overworld.worldType = worldtype;
        }
        InetAddress inetaddress = null;
        if (s2.length() > 0) {
            inetaddress = InetAddress.getByName(s2);
        }
        int i2 = this.propertyManagerObj.getIntProperty("server-port", 25565);
        logger.info("Starting Minecraft server on " + (s2.length() != 0 ? s2 : "*") + ":" + i2);
        try {
            this.networkServer = new NetworkListenThread(this, inetaddress, i2);
        }
        catch (IOException ioexception) {
            logger.warning("**** FAILED TO BIND TO PORT!");
            logger.log(Level.WARNING, "The exception was: " + ioexception.toString());
            logger.warning("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.onlineMode) {
            logger.warning("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            logger.warning("The server will make no attempt to authenticate usernames. Beware.");
            logger.warning("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            logger.warning("To change this, set \"online-mode\" to \"true\" in the server.settings file.");
        }
        this.configManager = new ServerConfigurationManager(this);
        for (int q2 = 0; q2 < Dimension.dimensionList.length; ++q2) {
            this.entityTracker[q2] = new EntityTracker(this, q2);
        }
        long l = System.nanoTime();
        String s1 = this.propertyManagerObj.getStringProperty("level-name", "world");
        String s22 = this.propertyManagerObj.getStringProperty("level-seed", "");
        long l1 = new Random().nextLong();
        if (s22.length() > 0) {
            try {
                l1 = Long.parseLong(s22);
            }
            catch (NumberFormatException numberformatexception) {
                l1 = s22.hashCode();
            }
        }
        logger.info("Preparing level \"" + s1 + "\"");
        this.initWorld(new SaveFormatMcRegionExtended(new File(".")), s1, l1);
        logger.info("Done (" + (System.nanoTime() - l) + "ns)! For help, type \"help\" or \"?\"");
        return true;
    }

    private void initWorld(nl isaveformat, String s2, long l) {
        if (isaveformat.a(s2)) {
            logger.info("Converting map!");
            isaveformat.a(s2, new ConvertProgressUpdater(this));
        }
        this.worldMngr = new WorldServer[Dimension.dimensionList.length];
        SaveOldDirServer saveolddir = new SaveOldDirServer(new File("."), s2, true);
        for (int i2 = 0; i2 < this.worldMngr.length; ++i2) {
            this.worldMngr[i2] = i2 == 0 ? new WorldServer(this, saveolddir, s2, i2, l) : new WorldServerMulti(this, saveolddir, s2, i2, l, this.worldMngr[0]);
            this.worldMngr[i2].a(new WorldManager(this, this.worldMngr[i2]));
            this.worldMngr[i2].q = this.propertyManagerObj.getBooleanProperty("spawn-monsters", true) ? 1 : 0;
            this.worldMngr[i2].a(this.propertyManagerObj.getBooleanProperty("spawn-monsters", true), this.spawnPeacefulMobs);
            this.configManager.setPlayerManager(this.worldMngr);
        }
        int c2 = 196;
        long l1 = System.currentTimeMillis();
        for (int j = 0; j < this.worldMngr.length; ++j) {
            logger.info("Preparing start region for level " + j);
            if (j != 0 && !this.propertyManagerObj.getBooleanProperty("allow-nether", true)) continue;
            WorldServer worldserver = this.worldMngr[j];
            br chunkcoordinates = worldserver.u();
            for (int k = -c2; k <= c2 && this.serverRunning; k += 16) {
                for (int i1 = -c2; i1 <= c2 && this.serverRunning; i1 += 16) {
                    long l2 = System.currentTimeMillis();
                    if (l2 < l1) {
                        l1 = l2;
                    }
                    if (l2 > l1 + 1000L) {
                        int j1 = (c2 * 2 + 1) * (c2 * 2 + 1);
                        int k1 = (k + c2) * (c2 * 2 + 1) + (i1 + 1);
                        this.outputPercentRemaining("Preparing spawn area", k1 * 100 / j1);
                        l1 = l2;
                    }
                    worldserver.chunkProviderServer.c(chunkcoordinates.a + k >> 4, chunkcoordinates.c + i1 >> 4);
                    while (worldserver.j() && this.serverRunning) {
                    }
                }
            }
        }
        this.clearCurrentTask();
    }

    private void outputPercentRemaining(String s2, int i2) {
        this.currentTask = s2;
        this.percentDone = i2;
        logger.info(s2 + ": " + i2 + "%");
    }

    private void clearCurrentTask() {
        this.currentTask = null;
        this.percentDone = 0;
    }

    private void saveServerWorld() {
        logger.info("Saving chunks");
        for (int i2 = 0; i2 < this.worldMngr.length; ++i2) {
            WorldServer worldserver = this.worldMngr[i2];
            worldserver.a(true, null);
            worldserver.func_30006_w();
        }
    }

    private void stopServer() {
        logger.info("Stopping server");
        if (this.configManager != null) {
            this.configManager.savePlayerStates();
        }
        for (int i2 = 0; i2 < this.worldMngr.length; ++i2) {
            WorldServer worldserver = this.worldMngr[i2];
            if (worldserver == null) continue;
            this.saveServerWorld();
        }
    }

    public void initiateShutdown() {
        this.serverRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.startServer()) {
                long l = System.currentTimeMillis();
                long l1 = 0L;
                while (this.serverRunning) {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    if (l3 > 2000L) {
                        logger.warning("Can't keep up! Did the system time change, or is the server overloaded?");
                        l3 = 2000L;
                    }
                    if (l3 < 0L) {
                        logger.warning("Time ran backwards! Did the system time change?");
                        l3 = 0L;
                    }
                    l1 += l3;
                    l = l2;
                    if (this.worldMngr[0].A()) {
                        this.doTick();
                        l1 = 0L;
                    } else {
                        while (l1 > 50L) {
                            l1 -= 50L;
                            this.doTick();
                        }
                    }
                    Thread.sleep(1L);
                }
                return;
            } else {
                while (this.serverRunning) {
                    this.commandLineParser();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedexception) {
                        interruptedexception.printStackTrace();
                    }
                }
            }
            return;
        }
        catch (Throwable throwable1) {
            throwable1.printStackTrace();
            logger.log(Level.SEVERE, "Unexpected exception", throwable1);
            while (this.serverRunning) {
                this.commandLineParser();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedexception1) {
                    interruptedexception1.printStackTrace();
                }
            }
            return;
        }
        finally {
            try {
                this.stopServer();
                this.serverStopped = true;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            finally {
                System.exit(0);
            }
        }
    }

    private void doTick() {
        ArrayList<String> arraylist = new ArrayList<String>();
        for (String s2 : field_6037_b.keySet()) {
            int i1 = (Integer)field_6037_b.get(s2);
            if (i1 > 0) {
                field_6037_b.put(s2, i1 - 1);
                continue;
            }
            arraylist.add(s2);
        }
        for (int i2 = 0; i2 < arraylist.size(); ++i2) {
            field_6037_b.remove(arraylist.get(i2));
        }
        eq.b();
        bt.b();
        ++this.deathTime;
        for (int j = 0; j < this.worldMngr.length; ++j) {
            if (j != 0 && !this.propertyManagerObj.getBooleanProperty("allow-nether", true)) continue;
            WorldServer worldserver = this.worldMngr[j];
            if (this.deathTime % 20 == 0) {
                this.configManager.sendPacketToAllPlayersInDimension(new hg(worldserver.t()), worldserver.dimension.dimId);
            }
            worldserver.l();
            while (worldserver.j()) {
            }
            worldserver.g();
        }
        this.networkServer.handleNetworkListenThread();
        this.configManager.onTick();
        for (int k = 0; k < this.entityTracker.length; ++k) {
            this.entityTracker[k].updateTrackedEntities();
        }
        for (int l = 0; l < this.field_9010_p.size(); ++l) {
            ((IUpdatePlayerListBox)this.field_9010_p.get(l)).update();
        }
        try {
            this.commandLineParser();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Unexpected exception while parsing console command", exception);
        }
    }

    public void addCommand(String s2, ICommandListener icommandlistener) {
        this.commands.add(new ServerCommand(s2, icommandlistener));
    }

    public void commandLineParser() {
        while (this.commands.size() > 0) {
            ServerCommand servercommand = (ServerCommand)this.commands.remove(0);
            this.commandHandler.handleCommand(servercommand);
        }
    }

    public void func_6022_a(IUpdatePlayerListBox iupdateplayerlistbox) {
        this.field_9010_p.add(iupdateplayerlistbox);
    }

    public static void main(String[] args) {
        jl.a();
        try {
            MinecraftServer minecraftserver = new MinecraftServer();
            if (!(GraphicsEnvironment.isHeadless() || args.length > 0 && args[0].equals("nogui"))) {
                ServerGUI.initGui(minecraftserver);
            }
            new ThreadServerApplication("Server thread", minecraftserver).start();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Failed to start the minecraft server", exception);
        }
    }

    public File getFile(String s2) {
        return new File(s2);
    }

    @Override
    public void log(String s2) {
        logger.info(s2);
    }

    public void logWarning(String s2) {
        logger.warning(s2);
    }

    @Override
    public String getUsername() {
        return "CONSOLE";
    }

    public WorldServer getWorldManager(int i2) {
        return this.worldMngr[i2];
    }

    public EntityTracker getEntityTracker(int i2) {
        return this.entityTracker[i2];
    }

    public static boolean isServerRunning(MinecraftServer minecraftserver) {
        return minecraftserver.serverRunning;
    }
}

