/*
 * Decompiled with CFR 0.152.
 */
package com.b100.json.element;

import com.b100.json.element.JsonElement;
import com.b100.utils.InvalidCharacterException;
import com.b100.utils.StringReader;
import com.b100.utils.StringWriter;

public class JsonString
implements JsonElement {
    public String value;

    public JsonString(String value) {
        this.value = value;
    }

    public JsonString(StringReader reader) {
        StringBuilder builder = new StringBuilder();
        reader.expectAndSkip('\"');
        while (true) {
            if (reader.get() == '\"') break;
            if (reader.get() == '\\') {
                reader.next();
                char next = reader.get();
                if (next == 'n' || next == 'N') {
                    builder.append('\n');
                } else if (next == '\\') {
                    builder.append('\\');
                } else {
                    throw new InvalidCharacterException(reader);
                }
                reader.next();
                continue;
            }
            builder.append(reader.getAndSkip());
        }
        reader.next();
        this.value = builder.toString();
    }

    public boolean equals(JsonString string2) {
        return this.value.equals(string2.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void write(StringWriter writer) {
        writer.write("\"");
        for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            if (c == '\n') {
                writer.write("\\n");
                continue;
            }
            if (c == '\t') {
                writer.write("\\t");
                continue;
            }
            if (c == '\\') {
                writer.write("\\\\");
                continue;
            }
            writer.write(c);
        }
        writer.write("\"");
    }
}

