/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ByteArrayTag
extends Tag<byte[]> {
    public ByteArrayTag() {
        this.setValue(new byte[0]);
    }

    public ByteArrayTag(byte[] array) {
        super(array);
    }

    @Override
    void write(DataOutput dos) throws IOException {
        dos.writeInt(((byte[])this.getValue()).length);
        dos.write((byte[])this.getValue());
    }

    @Override
    void read(DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new byte[length]);
        dis.readFully((byte[])this.getValue());
    }

    @Override
    public byte getId() {
        return 7;
    }

    public String toString() {
        if (((byte[])this.getValue()).length > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((byte[])this.getValue()).length + " bytes ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (byte b : (byte[])this.getValue()) {
            sb.append(b).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

