/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GLAllocation {
    public static List<Integer> displayLists = new ArrayList<Integer>();
    public static List<Integer> textureNames = new ArrayList<Integer>();

    public static synchronized int generateDisplayLists(int range) {
        int list = GL11.glGenLists((int)range);
        displayLists.add(list);
        displayLists.add(range);
        return list;
    }

    public static synchronized void generateTextureNames(IntBuffer intbuffer) {
        GL11.glGenTextures((IntBuffer)intbuffer);
        for (int i = intbuffer.position(); i < intbuffer.limit(); ++i) {
            textureNames.add(intbuffer.get(i));
        }
    }

    public static synchronized int generateTexture() {
        int tex = GL11.glGenTextures();
        textureNames.add(tex);
        return tex;
    }

    public static synchronized void deleteTexture(int tex) {
        GL11.glDeleteTextures((int)tex);
        for (int i = 0; i < textureNames.size(); ++i) {
            if (textureNames.get(i) != tex) continue;
            textureNames.remove(i);
            return;
        }
    }

    public static synchronized void deleteDisplayList(int displayList) {
        int displayListIndex = displayLists.indexOf(displayList);
        if (displayListIndex < 0) {
            return;
        }
        GL11.glDeleteLists((int)displayLists.get(displayListIndex), (int)displayLists.get(displayListIndex + 1));
        displayLists.remove(displayListIndex);
        displayLists.remove(displayListIndex);
    }

    public static synchronized void deleteTexturesAndDisplayLists() {
        for (int i = 0; i < displayLists.size(); i += 2) {
            GL11.glDeleteLists((int)displayLists.get(i), (int)displayLists.get(i + 1));
        }
        IntBuffer intbuffer = GLAllocation.createDirectIntBuffer(textureNames.size());
        for (Integer textureName : textureNames) {
            intbuffer.put(textureName);
        }
        intbuffer.flip();
        GL11.glDeleteTextures((IntBuffer)intbuffer);
        displayLists.clear();
        textureNames.clear();
    }

    public static synchronized ByteBuffer createDirectByteBuffer(int i) {
        ByteBuffer bytebuffer = ByteBuffer.allocateDirect(i).order(ByteOrder.nativeOrder());
        return bytebuffer;
    }

    public static IntBuffer createDirectIntBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asIntBuffer();
    }

    public static FloatBuffer createDirectFloatBuffer(int i) {
        return GLAllocation.createDirectByteBuffer(i << 2).asFloatBuffer();
    }
}

