/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import org.lwjgl.opengl.GL11;

public class GuiAchievement
extends Gui {
    private Minecraft theGame;
    private int achievementWindowWidth;
    private int achievementWindowHeight;
    private String name;
    private String desc;
    private Achievement theAchievement;
    private long startTime;
    private ItemEntityRenderer itemRender;
    private boolean isPermanent;

    public GuiAchievement(Minecraft minecraft) {
        this.theGame = minecraft;
        this.itemRender = new ItemEntityRenderer();
    }

    public boolean isDisplayingAchievement(Achievement achievement) {
        return this.theAchievement == achievement && this.startTime != 0L;
    }

    public void queueTakenAchievement(Achievement achievement) {
        this.name = I18n.getInstance().translateKey("gui.achievement.label.get");
        this.desc = achievement.getStatName();
        this.startTime = System.currentTimeMillis();
        this.theAchievement = achievement;
        this.isPermanent = false;
    }

    public void queueAchievementInformation(Achievement achievement) {
        this.name = achievement.getStatName();
        this.desc = achievement.getDescription();
        this.startTime = this.theAchievement == null ? System.currentTimeMillis() - 2500L : System.currentTimeMillis();
        this.theAchievement = achievement;
        this.isPermanent = true;
    }

    private void updateAchievementWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.theGame.resolution.width, (int)this.theGame.resolution.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.achievementWindowWidth = this.theGame.resolution.scaledWidth;
        this.achievementWindowHeight = this.theGame.resolution.scaledHeight;
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.achievementWindowWidth, (double)this.achievementWindowHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void updateAchievementWindow() {
        if (Minecraft.hasPaidCheckTime > 0L) {
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            Lighting.disable();
            this.updateAchievementWindowScale();
            String s = I18n.getInstance().translateKeyAndFormat("gui.achievement.label.unlicensed.1", Global.VERSION);
            String s1 = I18n.getInstance().translateKey("gui.achievement.label.unlicensed.2");
            String s2 = I18n.getInstance().translateKey("gui.achievement.label.unlicensed.3");
            this.theGame.fontRenderer.drawStringWithShadow(s, 2, 2, 0xFFFFFF);
            this.theGame.fontRenderer.drawStringWithShadow(s1, 2, 11, 0xFFFFFF);
            this.theGame.fontRenderer.drawStringWithShadow(s2, 2, 20, 0xFFFFFF);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
        }
        if (this.theAchievement == null || this.startTime == 0L || this.theGame.thePlayer == null) {
            return;
        }
        double animProgress = (double)(System.currentTimeMillis() - this.startTime) / 3000.0;
        if (this.isPermanent && animProgress > 0.5) {
            animProgress = 0.5;
        }
        if (!this.isPermanent && (animProgress < 0.0 || animProgress > 1.0)) {
            this.startTime = 0L;
            return;
        }
        this.updateAchievementWindowScale();
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        double d1 = animProgress * 2.0;
        if (d1 > 1.0) {
            d1 = 2.0 - d1;
        }
        d1 *= 4.0;
        if ((d1 = 1.0 - d1) < 0.0) {
            d1 = 0.0;
        }
        d1 *= d1;
        d1 *= d1;
        int i = this.achievementWindowWidth - 160;
        int j = (int)(-d1 * 36.0);
        int k = this.theGame.renderEngine.getTexture("/assets/minecraft/textures/gui/achievement/bg.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)k);
        GL11.glDisable((int)2896);
        this.drawTexturedModalRect(i, j, 96, 202, 160, 32);
        if (this.isPermanent) {
            this.theGame.fontRenderer.func_27278_a(this.desc, i + 30, j + 7, 120, -1);
        } else {
            this.theGame.fontRenderer.drawString(this.name, i + 30, j + 7, -256);
            this.theGame.fontRenderer.drawString(this.desc, i + 30, j + 18, -1);
        }
        GL11.glDepthMask((boolean)true);
        Lighting.enableInventoryLight();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        Item achievementItem = Item.itemsList[this.theAchievement.itemId];
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(achievementItem)).renderItemIntoGui(Tessellator.instance, this.theGame.fontRenderer, this.theGame.renderEngine, achievementItem.getDefaultStack(), i + 8, j + 8, 1.0f);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        Lighting.disable();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }
}

