/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.drawing;

import java.util.Stack;
import net.minecraft.client.gui.drawing.IDrawableSurface;
import net.minecraft.core.util.collection.Pair;

public final class DrawableEditor<T> {
    private final IDrawableSurface<T> surface;

    public DrawableEditor(IDrawableSurface<T> surface) {
        this.surface = surface;
    }

    public void drawPixel(int x, int y, T value) {
        this.surface.setPixelValue(x, y, value);
    }

    public void drawLine(int x0, int y0, int x1, int y1, T value, int size) {
        if (Math.abs(y1 - y0) < Math.abs(x1 - x0)) {
            if (x0 > x1) {
                this.doDrawLine(x1, y1, x0, y0, value, size, false);
            } else {
                this.doDrawLine(x0, y0, x1, y1, value, size, false);
            }
        } else if (y0 > y1) {
            this.doDrawLine(y1, x1, y0, x0, value, size, true);
        } else {
            this.doDrawLine(y0, x0, y1, x1, value, size, true);
        }
    }

    private void doDrawLine(int a0, int b0, int a1, int b1, T value, int size, boolean swapped) {
        int sizeHalfMinus = (size - 1) / 2;
        int sizeHalfPlus = (size - 1) / 2;
        if (size % 2 == 0) {
            ++sizeHalfPlus;
        }
        int da = a1 - a0;
        int db = b1 - b0;
        int bi = 1;
        if (db < 0) {
            bi = -1;
            db = -db;
        }
        int D = 2 * db - da;
        int b = b0;
        for (int a = a0; a <= a1; ++a) {
            for (int dx = -sizeHalfMinus; dx <= sizeHalfPlus; ++dx) {
                for (int dy = -sizeHalfMinus; dy <= sizeHalfPlus; ++dy) {
                    if (swapped) {
                        this.drawPixel(dx + b, dy + a, value);
                        continue;
                    }
                    this.drawPixel(dx + a, dy + b, value);
                }
            }
            if (D > 0) {
                b += bi;
                D += 2 * (db - da);
                continue;
            }
            D += 2 * db;
        }
    }

    public void drawRectangle(int x0, int y0, int x1, int y1, T value) {
        int temp;
        if (x0 > x1) {
            temp = x1;
            x1 = x0;
            x0 = temp;
        }
        if (y0 > y1) {
            temp = y1;
            y1 = y0;
            y0 = temp;
        }
        for (int x = x0; x <= x1; ++x) {
            for (int y = y0; y <= y1; ++y) {
                if (x != x0 && x != x1 && y != y0 && y != y1) continue;
                this.drawPixel(x, y, value);
            }
        }
    }

    public void drawEllipse(int x0, int y0, int x1, int y1, T value) {
        int temp;
        if (x0 > x1) {
            temp = x1;
            x1 = x0;
            x0 = temp;
        }
        if (y0 > y1) {
            temp = y1;
            y1 = y0;
            y0 = temp;
        }
        if (x1 - x0 < 2 || y1 - y0 < 2) {
            this.drawRectangle(x0, y0, x1, y1, value);
            return;
        }
        ++y1;
        boolean xSkipMiddle = false;
        boolean ySkipMiddle = false;
        if ((++x1 - x0) % 2 == 0) {
            xSkipMiddle = true;
        }
        if ((y1 - y0) % 2 == 0) {
            ySkipMiddle = true;
        }
        int steps = 0;
        int xRadius = (x1 - x0) / 2;
        int yRadius = (y1 - y0) / 2;
        int cx = x0 + xRadius;
        int cy = y0 + yRadius;
        int twoASquare = 2 * xRadius * xRadius;
        int twoBSquare = 2 * yRadius * yRadius;
        int x = xRadius;
        int y = 0;
        int xChange = yRadius * yRadius * (1 - 2 * xRadius);
        int yChange = xRadius * xRadius;
        int ellipseError = 0;
        int stoppingX = twoBSquare * xRadius;
        int stoppingY = 0;
        while (stoppingX >= stoppingY) {
            this.drawEllipsePoints(cx, cy, x, y, xSkipMiddle, ySkipMiddle, value);
            ++y;
            stoppingY += twoASquare;
            if (2 * (ellipseError += (yChange += twoASquare)) + xChange > 0) {
                --x;
                stoppingX -= twoBSquare;
                ellipseError += xChange;
                xChange += twoBSquare;
            }
            if (++steps <= 100) continue;
        }
        steps = 0;
        x = 0;
        y = yRadius;
        xChange = yRadius * yRadius;
        yChange = xRadius * xRadius * (1 - 2 * yRadius);
        ellipseError = 0;
        stoppingX = 0;
        stoppingY = twoASquare * yRadius;
        while (stoppingX <= stoppingY) {
            this.drawEllipsePoints(cx, cy, x, y, xSkipMiddle, ySkipMiddle, value);
            ++x;
            stoppingX += twoBSquare;
            if (2 * (ellipseError += (xChange += twoBSquare)) + yChange > 0) {
                --y;
                stoppingY -= twoASquare;
                ellipseError += yChange;
                yChange += twoASquare;
            }
            if (++steps <= 100) continue;
            break;
        }
    }

    private void drawEllipsePoints(int cx, int cy, int x, int y, boolean xSkipMiddle, boolean ySkipMiddle, T value) {
        int xOffset = 0;
        int yOffset = 0;
        if (xSkipMiddle) {
            xOffset = 1;
        }
        if (ySkipMiddle) {
            yOffset = 1;
        }
        this.drawPixel(cx + x - xOffset, cy + y - yOffset, value);
        this.drawPixel(cx - x, cy + y - yOffset, value);
        this.drawPixel(cx - x, cy - y, value);
        this.drawPixel(cx + x - xOffset, cy - y, value);
    }

    public void floodFill(int x, int y, T value) {
        Stack<Pair<Integer, Integer>> floodFillStack = new Stack<Pair<Integer, Integer>>();
        T floodColor = this.surface.getPixelValue(x, y);
        if (floodColor == value) {
            return;
        }
        floodFillStack.push(Pair.of(x, y));
        while (!floodFillStack.isEmpty()) {
            Pair item = (Pair)floodFillStack.pop();
            if (this.surface.getPixelValue((Integer)item.getLeft(), (Integer)item.getRight()) != floodColor) continue;
            this.drawPixel((Integer)item.getLeft(), (Integer)item.getRight(), value);
            if ((Integer)item.getLeft() - 1 >= 0) {
                floodFillStack.push(Pair.of((Integer)item.getLeft() - 1, (Integer)item.getRight()));
            }
            if ((Integer)item.getLeft() + 1 < this.surface.getWidth()) {
                floodFillStack.push(Pair.of((Integer)item.getLeft() + 1, (Integer)item.getRight()));
            }
            if ((Integer)item.getRight() - 1 >= 0) {
                floodFillStack.push(Pair.of((Integer)item.getLeft(), (Integer)item.getRight() - 1));
            }
            if ((Integer)item.getRight() + 1 >= this.surface.getHeight()) continue;
            floodFillStack.push(Pair.of((Integer)item.getLeft(), (Integer)item.getRight() + 1));
        }
    }
}

