/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListSelectorButton;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerSlider;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;

public class EntityFireflyEntry
extends EntityEntry<EntityFireflyCluster> {
    @Override
    public void onTick(EntityFireflyCluster fireflyCluster) {
        Random random = fireflyCluster.world.rand;
        double dy = (random.nextFloat() * 2.0f - 1.0f) * fireflyCluster.bbHeight;
        double dx = (random.nextFloat() * 2.0f - 1.0f) * fireflyCluster.bbWidth;
        double dz = (random.nextFloat() * 2.0f - 1.0f) * fireflyCluster.bbWidth;
        if (random.nextInt(Math.max(1, 10 - fireflyCluster.getFireflyCount())) == 0) {
            fireflyCluster.world.spawnParticle(fireflyCluster.getColor().getParticleName(), fireflyCluster.x + dx, fireflyCluster.y + dy, fireflyCluster.z + dz, fireflyCluster.xd, fireflyCluster.yd, fireflyCluster.zd, 0, 99999.0);
        }
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, EntityFireflyCluster fireflyCluster) {
        ArrayList<GuiButton> buttonList = new ArrayList<GuiButton>();
        GuiListenerSlider slider = new GuiListenerSlider(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.fireflycluster.slider.size", 0), 0.0f);
        slider.setOnValueChanged(() -> {
            float f = slider.sliderValue;
            Objects.requireNonNull(fireflyCluster);
            fireflyCluster.setClusterSize((int)(f * 6.0f));
            slider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.fireflycluster.slider.size", fireflyCluster.getClusterSize());
        });
        GuiListSelectorButton<EntityFireflyCluster.FireflyColor> button = new GuiListSelectorButton<EntityFireflyCluster.FireflyColor>(-1, -120, slider.yPosition + 21, 120, 20, I18n.getInstance().translateKey("model.category.entity.fireflycluster.button.cycle"), EntityFireflyCluster.FireflyColor.fireFlyColors.values(), EntityFireflyCluster.FireflyColor.GREEN){

            @Override
            public String getNameFromElement(EntityFireflyCluster.FireflyColor element) {
                return element.getParticleName();
            }
        };
        button.setActionListener(() -> fireflyCluster.setColor((EntityFireflyCluster.FireflyColor)button.getCurrentElement()));
        buttonList.add(slider);
        buttonList.add(button);
        return buttonList;
    }

    @Override
    public EntityFireflyCluster getEntityInstance(Minecraft mc, World world) {
        EntityFireflyCluster cluster = new EntityFireflyCluster(world);
        cluster.setClusterSize(0);
        return cluster;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

