/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerSlider;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityItemEntry
extends EntityEntry<EntityItem> {
    @Override
    public void onTick(EntityItem entityItem) {
        ++entityItem.age;
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, final EntityItem entityItem) {
        ArrayList<GuiButton> buttonList = new ArrayList<GuiButton>();
        entityItem.item = Block.stone.getDefaultStack();
        GuiTextCycle<Integer> itemIdCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, 0, 120, 20, Integer.valueOf(1)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return GuiModelViewer.cycleItemId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, Item.itemsList.length);
                }
                catch (Exception exception) {
                    return entityItem.item.itemID;
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        itemIdCycle.textField.setPrefaceText("ID: ");
        itemIdCycle.textField.setPlaceholder("Item ID");
        GuiTextCycle<Integer> metaCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, itemIdCycle.yPosition + 21, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return current + offset & 0x3FFF;
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = Integer.parseInt(s);
                    return MathHelper.clamp(id, 0, 16383);
                }
                catch (Exception exception) {
                    return entityItem.item.getMetadata();
                }
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        metaCycle.textField.setPrefaceText("Meta: ");
        metaCycle.textField.setPlaceholder("Meta");
        GuiListenerSlider sizeSlider = new GuiListenerSlider(-1, -120, metaCycle.yPosition + 21, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.item.slider.size", 1), 0.015625f);
        itemIdCycle.setOnValueChanged(() -> {
            entityItem.item = new ItemStack((Integer)itemIdCycle.getCurrentElement(), (int)(sizeSlider.sliderValue * 64.0f), (int)((Integer)metaCycle.getCurrentElement()));
        });
        metaCycle.setOnValueChanged(() -> {
            entityItem.item = new ItemStack((Integer)itemIdCycle.getCurrentElement(), (int)(sizeSlider.sliderValue * 64.0f), (int)((Integer)metaCycle.getCurrentElement()));
        });
        sizeSlider.setOnValueChanged(() -> {
            entityItem.item.stackSize = (int)(sizeSlider.sliderValue * 64.0f);
            sizeSlider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.item.slider.size", entityItem.item.stackSize);
        });
        buttonList.add(itemIdCycle);
        buttonList.add(metaCycle);
        buttonList.add(sizeSlider);
        return buttonList;
    }

    @Override
    public EntityItem getEntityInstance(Minecraft mc, World world) {
        return new EntityItem(world);
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

