/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.modelviewer.elements.IActionListener;
import net.minecraft.client.gui.modelviewer.elements.IKeyListener;
import net.minecraft.client.gui.modelviewer.elements.IListenerElement;

public class GuiListenerButton
extends GuiButton
implements IListenerElement {
    protected IActionListener action;
    protected IKeyListener keyListener;
    protected Runnable onValueChanged;

    public GuiListenerButton(int id, int xPosition, int yPosition, String text) {
        super(id, xPosition, yPosition, text);
    }

    public GuiListenerButton(int id, int xPosition, int yPosition, int width, int height, String text) {
        super(id, xPosition, yPosition, width, height, text);
    }

    @Override
    public boolean mouseClicked(Minecraft mc, int mouseX, int mouseY) {
        boolean flag = super.mouseClicked(mc, mouseX, mouseY);
        if (flag) {
            this.onClick(mc, mouseX, mouseY);
        }
        return flag;
    }

    protected void onClick(Minecraft mc, int mouseX, int mouseY) {
        if (this.action != null) {
            this.action.onInteract();
            this.onValueChanged();
        }
    }

    @Override
    public void setActionListener(IActionListener listener) {
        this.action = listener;
    }

    @Override
    public void setKeyListener(IKeyListener listener) {
        this.keyListener = listener;
    }

    @Override
    public void setOnValueChanged(Runnable runnable) {
        this.onValueChanged = runnable;
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (this.keyListener != null) {
            this.keyListener.onKeyPressed(key);
        }
    }

    @Override
    public void onValueChanged() {
        if (this.onValueChanged != null) {
            this.onValueChanged.run();
        }
    }

    public void tick() {
    }
}

