/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.option.IntegerOption;

public class IntegerOptionComponent
extends ButtonComponent {
    private final IntegerOption option;
    private final GuiButton button;

    public IntegerOptionComponent(IntegerOption option) {
        super("options." + option.name);
        this.option = option;
        this.button = new GuiButton(0, 0, 0, 150, 20, this.option.getDisplayString());
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.option.set((Integer)this.option.value + 1);
        this.option.onUpdate();
        this.button.displayString = this.option.getDisplayString();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }

    @Override
    public void resetValue() {
        this.option.set((Integer)this.option.getDefaultValue());
        this.button.displayString = this.option.getDisplayStringValue();
        this.option.onUpdate();
    }

    @Override
    public void init(Minecraft mc) {
        this.button.displayString = this.option.getDisplayStringValue();
    }

    @Override
    public boolean isDefault() {
        return ((Integer)this.option.value).equals(this.option.getDefaultValue());
    }
}

