/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.paged;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.paged.PageComponent;
import net.minecraft.core.item.ItemStack;

public class Page {
    private static final int COMPONENT_SPACING = 4;
    private final String translationKey;
    private final List<PageComponent> components = new ArrayList<PageComponent>();
    private final ItemStack icon;

    public Page(String translationKey, ItemStack icon) {
        this.translationKey = translationKey;
        this.icon = icon;
    }

    public Page withComponent(PageComponent component) {
        this.components.add(component);
        return this;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public List<PageComponent> getComponents() {
        return this.components;
    }

    public void initComponents(Minecraft mc) {
        for (PageComponent component : this.components) {
            component.init(mc);
        }
    }

    public int getHeight() {
        int height = 0;
        for (PageComponent component : this.components) {
            height += component.getHeight() + 4;
        }
        return height -= 4;
    }

    public ItemStack getIcon() {
        return this.icon;
    }
}

