/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import net.java.games.input.Component;
import net.minecraft.client.input.controller.IButton;
import net.minecraft.client.input.controller.IButtonListener;

public class Button
implements IButton {
    public final String name;
    public Component component;
    public IButtonListener buttonListener;
    private boolean pressed = false;
    private boolean cancelled = false;
    private boolean pressedThisFrame;
    private boolean releasedThisFrame;
    private int holdTime;

    public Button(String name, Component component, IButtonListener buttonListener) {
        this.name = name;
        this.component = component;
        this.buttonListener = buttonListener;
    }

    @Override
    public boolean isPressed() {
        if (this.cancelled) {
            return false;
        }
        return this.pressed;
    }

    @Override
    public boolean pressedThisFrame() {
        if (this.cancelled) {
            return false;
        }
        return this.pressedThisFrame;
    }

    @Override
    public boolean releasedThisFrame() {
        if (this.cancelled) {
            return false;
        }
        return this.releasedThisFrame;
    }

    @Override
    public void update() {
        boolean p = this.buttonListener.isPressed(this.component);
        if (!p) {
            this.cancelled = false;
            this.holdTime = 0;
        } else {
            ++this.holdTime;
        }
        this.pressedThisFrame = p && !this.pressed;
        this.releasedThisFrame = !p && this.pressed;
        this.pressed = p;
    }

    @Override
    public int getHoldTime() {
        return this.holdTime;
    }

    @Override
    public void cancelButtonPress() {
        this.cancelled = true;
        this.holdTime = 0;
    }

    public void tick() {
        ++this.holdTime;
    }
}

