/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.thread;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.render.DownloadedTexture;
import net.minecraft.client.render.ImageParser;

public class ThreadDownloadImage
extends Thread {
    private static int counter = 0;
    public final String url;
    public final ImageParser imageParser;
    public final DownloadedTexture texture;

    public ThreadDownloadImage(DownloadedTexture texture, String url, ImageParser imageBuffer) {
        this.texture = texture;
        this.url = url;
        this.imageParser = imageBuffer;
        this.setName("DownloadImage " + counter++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection connection = null;
        try {
            if (this.url == null) {
                return;
            }
            URL u = new URL(this.url);
            connection = (HttpURLConnection)u.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            if (connection.getResponseCode() / 100 == 4) {
                return;
            }
            InputStream inputStream = connection.getInputStream();
            BufferedImage image = ImageIO.read(inputStream);
            this.texture.image = this.imageParser != null ? this.imageParser.parseImage(image) : image;
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

