/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;

public class PlayerControllerSP
extends PlayerController {
    public PlayerControllerSP(Minecraft minecraft) {
        super(minecraft);
    }

    @Override
    public boolean destroyBlock(int x, int y, int z, Side side, EntityPlayer player) {
        if (!player.getGamemode().canInteract()) {
            return false;
        }
        int id = this.mc.theWorld.getBlockId(x, y, z);
        int meta = this.mc.theWorld.getBlockMetadata(x, y, z);
        TileEntity tileEntity = this.mc.theWorld.getBlockTileEntity(x, y, z);
        boolean removed = super.destroyBlock(x, y, z, side, player);
        ItemStack item = this.mc.thePlayer.getCurrentEquippedItem();
        if (item != null) {
            item.onDestroyBlock(this.mc.theWorld, id, x, y, z, side, this.mc.thePlayer);
        }
        if (removed && this.mc.thePlayer.getGamemode().dropBlockOnBreak()) {
            Block.blocksList[id].harvestBlock(this.mc.theWorld, this.mc.thePlayer, x, y, z, meta, tileEntity);
        }
        if (item != null && item.stackSize <= 0) {
            this.mc.thePlayer.destroyCurrentEquippedItem();
        }
        return removed;
    }
}

