/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.GLAllocation;
import org.lwjgl.opengl.GL11;

public class Texture {
    private int id;

    public boolean generate() {
        if (this.isGenerated()) {
            return false;
        }
        this.id = GLAllocation.generateTexture();
        if (!this.isGenerated()) {
            throw new RuntimeException("Texture not created!");
        }
        return true;
    }

    public boolean delete() {
        if (!this.isGenerated()) {
            return false;
        }
        GLAllocation.deleteTexture(this.id);
        this.id = 0;
        return true;
    }

    public boolean bind() {
        if (!this.isGenerated()) {
            return false;
        }
        GL11.glBindTexture((int)3553, (int)this.id);
        return true;
    }

    public void unbind() {
        GL11.glBindTexture((int)3553, (int)0);
    }

    public boolean isGenerated() {
        return this.id != 0;
    }

    public int getWidth() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }

    public int getHeight() {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public int id() {
        return this.id;
    }
}

