/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelTrapDoor;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTrapDoor;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

public class BlockModelTrapDoorPainted<T extends Block>
extends BlockModelTrapDoor<T> {
    public static final IconCoordinate[] topTextures = new IconCoordinate[16];
    public static final IconCoordinate[] sideTextures = new IconCoordinate[16];

    public BlockModelTrapDoorPainted(Block block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4 & 0xF;
        int orientation = data & 3;
        if (BlockTrapDoor.isTrapdoorOpen(data)) {
            int index = Sides.orientationLookUpTrapdoorOpen[6 * orientation + side.getId()];
            if (index < 2) {
                return topTextures[color];
            }
            return sideTextures[color];
        }
        if (side.getAxis() == Axis.Y) {
            return topTextures[color];
        }
        return sideTextures[color];
    }

    static {
        for (int i = 0; i < 16; ++i) {
            BlockModelTrapDoorPainted.topTextures[i] = TextureRegistry.getTexture("minecraft:block/trapdoor_planks_oak_" + ItemDye.dyeColors[15 - i] + "_top");
            BlockModelTrapDoorPainted.sideTextures[i] = TextureRegistry.getTexture("minecraft:block/trapdoor_planks_oak_" + ItemDye.dyeColors[15 - i] + "_side");
        }
    }
}

