/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.camera;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.core.entity.EntityLiving;

public abstract class EntityCamera
implements ICamera {
    protected final Minecraft mc;
    private final CameraFrustum frustum;
    public final EntityLiving entity;

    public EntityCamera(Minecraft mc, EntityLiving entity) {
        this.mc = mc;
        this.entity = entity;
        this.frustum = new CameraFrustum(this);
    }

    @Override
    public boolean showPlayer() {
        return false;
    }

    @Override
    public void tick() {
    }

    @Override
    public void applyGlTransformations() {
    }

    @Override
    public double getX(float partialTick) {
        if (partialTick == 1.0f) {
            return this.entity.x;
        }
        return this.entity.xo + (this.entity.x - this.entity.xo) * (double)partialTick;
    }

    @Override
    public double getY(float partialTick) {
        if (partialTick == 1.0f) {
            return this.entity.y;
        }
        return this.entity.yo + (this.entity.y - this.entity.yo) * (double)partialTick;
    }

    @Override
    public double getZ(float partialTick) {
        if (partialTick == 1.0f) {
            return this.entity.z;
        }
        return this.entity.zo + (this.entity.z - this.entity.zo) * (double)partialTick;
    }

    @Override
    public double getXRot(float partialTick) {
        if (partialTick == 1.0f) {
            return this.entity.xRot;
        }
        return this.entity.xRotO + (this.entity.xRot - this.entity.xRotO) * partialTick;
    }

    @Override
    public double getYRot(float partialTick) {
        if (partialTick == 1.0f) {
            return this.entity.yRot;
        }
        return this.entity.yRotO + (this.entity.yRot - this.entity.yRotO) * partialTick;
    }

    @Override
    public double getFov() {
        return ((Float)this.mc.gameSettings.FoV.value).floatValue();
    }

    @Override
    public CameraFrustum getFrustum() {
        return this.frustum;
    }
}

