/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.util.Random;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.util.helper.MathHelper;

public class DynamicTexturePortal
extends DynamicTexture {
    private boolean altTexture;
    private int portalTickCounter = 0;
    private byte[][] portalTextureData;

    public DynamicTexturePortal(boolean altTexture) {
        this.altTexture = altTexture;
    }

    @Override
    public void postInit() {
        this.setTexture(TextureRegistry.getTexture("minecraft:block/portal_nether"));
        Random var1 = new Random(100L);
        this.portalTextureData = new byte[32][this.texture.getArea() * 4];
        for (int i = 0; i < 32; ++i) {
            for (int x = 0; x < this.texture.width; ++x) {
                for (int y = 0; y < this.texture.height; ++y) {
                    int b;
                    float f = 0.0f;
                    for (b = 0; b < 2; ++b) {
                        float swirlY;
                        float swirlX;
                        if (this.altTexture) {
                            swirlX = 0.0f;
                            swirlY = 0.0f;
                        } else {
                            swirlX = b * (this.texture.width / 2);
                            swirlY = b * (this.texture.height / 2);
                        }
                        float var9 = ((float)x - swirlX) / (float)this.texture.width * 2.0f;
                        float var10 = ((float)y - swirlY) / (float)this.texture.height * 2.0f;
                        if (var9 < -1.0f) {
                            var9 += 2.0f;
                        }
                        if (var9 >= 1.0f) {
                            var9 -= 2.0f;
                        }
                        if (var10 < -1.0f) {
                            var10 += 2.0f;
                        }
                        if (var10 >= 1.0f) {
                            var10 -= 2.0f;
                        }
                        float var11 = var9 * var9 + var10 * var10;
                        float var12 = (float)Math.atan2(var10, var9) + ((float)i / 32.0f * (float)Math.PI * 2.0f - var11 * 10.0f + (float)(b * 2)) * (float)(b * 2 - 1);
                        var12 = (MathHelper.sin(var12) + 1.0f) / 2.0f;
                        f += (var12 /= var11 + 1.0f) * 0.5f;
                    }
                    b = (int)((f += var1.nextFloat() * 0.1f) * 100.0f + 155.0f);
                    int r = (int)(f * f * 200.0f + 55.0f);
                    int g = (int)(f * f * f * f * 255.0f);
                    int a = (int)(f * 100.0f + 155.0f);
                    int l = y * this.texture.width + x;
                    this.portalTextureData[i][l * 4 + 0] = (byte)r;
                    this.portalTextureData[i][l * 4 + 1] = (byte)g;
                    this.portalTextureData[i][l * 4 + 2] = (byte)b;
                    this.portalTextureData[i][l * 4 + 3] = (byte)a;
                }
            }
        }
    }

    @Override
    public void update() {
        ++this.portalTickCounter;
        byte[] var1 = this.portalTextureData[this.portalTickCounter & 0x1F];
        for (int i = 0; i < this.texture.getArea(); ++i) {
            int r = var1[i * 4 + 0] & 0xFF;
            int g = var1[i * 4 + 1] & 0xFF;
            int b = var1[i * 4 + 2] & 0xFF;
            int a = var1[i * 4 + 3] & 0xFF;
            this.imageData[i * 4 + 0] = (byte)r;
            this.imageData[i * 4 + 1] = (byte)g;
            this.imageData[i * 4 + 2] = (byte)b;
            this.imageData[i * 4 + 3] = (byte)a;
        }
    }
}

