/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelCreeper;
import net.minecraft.core.entity.monster.EntityCreeper;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class CreeperRenderer
extends LivingRenderer<EntityCreeper> {
    private ModelBase field_27008_a = new ModelCreeper(2.0f);

    public CreeperRenderer() {
        super(new ModelCreeper(), 0.5f);
    }

    protected void updateCreeperScale(EntityCreeper entity, float f) {
        float f1 = entity.setCreeperFlashTime(f);
        float f2 = 1.0f + MathHelper.sin(f1 * 100.0f) * f1 * 0.01f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        f1 *= f1;
        f1 *= f1;
        float f3 = (1.0f + f1 * 0.4f) * f2;
        float f4 = (1.0f + f1 * 0.1f) / f2;
        GL11.glScalef((float)f3, (float)f4, (float)f3);
    }

    protected int updateCreeperColorMultiplier(EntityCreeper entity, float f, float f1) {
        float f2 = entity.setCreeperFlashTime(f1);
        if ((int)(f2 * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f2 * 0.2f * 255.0f);
        if (i < 0) {
            i = 0;
        }
        if (i > 255) {
            i = 255;
        }
        int c = 255;
        int c1 = 255;
        int c2 = 255;
        return i << 24 | c << 16 | c1 << 8 | c2;
    }

    protected boolean func_27006_a(EntityCreeper entity, int i, float f) {
        if (entity.getPowered()) {
            if (i == 1) {
                float f1 = (float)entity.tickCount + f;
                this.loadTexture("/armor/power.png");
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                float f2 = f1 * 0.01f;
                float f3 = f1 * 0.01f;
                GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
                this.setRenderPassModel(this.field_27008_a);
                GL11.glMatrixMode((int)5888);
                GL11.glEnable((int)3042);
                float f4 = 0.5f;
                GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glBlendFunc((int)1, (int)1);
                return true;
            }
            if (i == 2) {
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
            }
        }
        return false;
    }

    protected boolean func_27007_b(EntityCreeper entity, int i, float f) {
        return false;
    }

    @Override
    protected void preRenderCallback(EntityCreeper entity, float f) {
        this.updateCreeperScale(entity, f);
    }

    @Override
    protected int getColorMultiplier(EntityCreeper entity, float f, float f1) {
        return this.updateCreeperColorMultiplier(entity, f, f1);
    }

    @Override
    protected boolean shouldRenderPass(EntityCreeper entity, int renderPass, float partialTick) {
        return this.func_27006_a(entity, renderPass, partialTick);
    }

    @Override
    protected boolean shouldRenderPassB(EntityCreeper entity, int renderPass, float partialTick) {
        return this.func_27007_b(entity, renderPass, partialTick);
    }
}

