/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityOtherPlayerMP;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemModelBow
extends ItemModelStandard {
    public ItemModelBow(Item item, String namespace) {
        super(item, namespace);
    }

    @Override
    public void renderItem(Tessellator tessellator, ItemRenderer renderer, ItemStack itemstack, Entity entity, float brightness, boolean handheldTransform) {
        super.renderItem(tessellator, renderer, itemstack, entity, brightness, handheldTransform);
        Item nextArrow = null;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            nextArrow = this.getNextArrow(entityplayer);
        }
        if (entity instanceof EntitySkeleton && ((EntitySkeleton)entity).attackTime < 5) {
            nextArrow = Item.ammoArrow;
        }
        if (nextArrow != null) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0625f);
            ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(nextArrow)).renderItem(tessellator, renderer, itemstack, entity, brightness, false);
        }
    }

    @Override
    public void renderItemIntoGui(Tessellator tessellator, FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        Minecraft mc = Minecraft.getMinecraft(this);
        Item nextArrow = this.getNextArrow(mc.thePlayer);
        if (itemStack == mc.thePlayer.getHeldItem() && nextArrow != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2884);
            ItemModelStandard arrowModel = (ItemModelStandard)ItemModelDispatcher.getInstance().getDispatch(nextArrow);
            IconCoordinate textureIndex = arrowModel.getIcon(mc.thePlayer, nextArrow.getDefaultStack());
            if (textureIndex != null) {
                GL11.glDisable((int)2896);
                textureIndex.parentAtlas.bindTexture();
                if (this.useColor) {
                    int color = this.getColor(itemStack);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
                } else {
                    GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                }
                this.renderTexturedQuad(tessellator, x, y, textureIndex, true, false);
                GL11.glEnable((int)2896);
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
        super.renderItemIntoGui(tessellator, fontrenderer, renderengine, itemStack, x, y, brightness, alpha);
    }

    public Item getNextArrow(EntityPlayer player) {
        if (player instanceof EntityOtherPlayerMP) {
            int id = player.getArrowId();
            if (id < 0 || id >= Item.itemsList.length) {
                return null;
            }
            return Item.itemsList[id];
        }
        return player.getNextArrow();
    }

    @Override
    public void heldTransformThirdPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float scale = 0.625f;
        GL11.glScalef((float)0.625f, (float)-0.625f, (float)0.625f);
        GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

