/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement;

import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.achievement.stat.IStatStringFormat;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;

public class Achievement
extends Stat {
    public final int x;
    public final int y;
    public final Achievement parent;
    private final String description;
    private IStatStringFormat statStringFormatter;
    public final int itemId;
    private boolean isSpecial;

    public Achievement(int id, String name, int x, int y, Item item, Achievement parent) {
        this(id, name, x, y, item.id, parent);
    }

    public Achievement(int i, String name, int x, int y, Block block, Achievement parent) {
        this(i, name, x, y, block.id, parent);
    }

    public Achievement(int id, String name, int x, int y, int itemId, Achievement parent) {
        super(0x500000 + id, "achievement." + name);
        this.itemId = itemId;
        this.description = "achievement." + name;
        this.x = x;
        this.y = y;
        if (x < AchievementList.minX) {
            AchievementList.minX = x;
        }
        if (y < AchievementList.minY) {
            AchievementList.minY = y;
        }
        if (x > AchievementList.maxX) {
            AchievementList.maxX = x;
        }
        if (y > AchievementList.maxY) {
            AchievementList.maxY = y;
        }
        this.parent = parent;
    }

    public Achievement setClientsideAchievement() {
        this.clientside = true;
        return this;
    }

    public Achievement setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public Achievement registerAchievement() {
        super.registerStat();
        AchievementList.achievementList.add(this);
        return this;
    }

    @Override
    public boolean isAchievement() {
        return true;
    }

    public String getDescription() {
        if (this.statStringFormatter != null) {
            return this.statStringFormatter.formatString(I18n.getInstance().translateDescKey(this.description));
        }
        return I18n.getInstance().translateDescKey(this.description);
    }

    public Achievement setStatStringFormatter(IStatStringFormat istatstringformat) {
        this.statStringFormatter = istatstringformat;
        return this;
    }

    public boolean getSpecial() {
        return this.isSpecial;
    }

    @Override
    public Stat registerStat() {
        return this.registerAchievement();
    }

    @Override
    public Stat setClientside() {
        return this.setClientsideAchievement();
    }
}

