/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumSleepStatus;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.chunk.ChunkCoordinates;

public class BlockBed
extends Block {
    public static final int[][] headBlockToFootBlockMap = new int[][]{{0, 1}, {-1, 0}, {0, -1}, {1, 0}};

    public BlockBed(String key, int id) {
        super(key, id, Material.wood);
        this.setBounds();
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, EntityPlayer player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (!BlockBed.isBlockFootOfBed(meta)) {
            int dir = BlockBed.getDirectionFromMetadata(meta);
            if (world.getBlockId(x += headBlockToFootBlockMap[dir][0], y, z += headBlockToFootBlockMap[dir][1]) != this.id) {
                return true;
            }
            meta = world.getBlockMetadata(x, y, z);
        }
        if (!world.worldType.mayRespawn()) {
            double d = (double)x + 0.5;
            double d1 = (double)y + 0.5;
            double d2 = (double)z + 0.5;
            world.setBlockWithNotify(x, y, z, 0);
            int dir = BlockBed.getDirectionFromMetadata(meta);
            if (world.getBlockId(x += headBlockToFootBlockMap[dir][0], y, z += headBlockToFootBlockMap[dir][1]) == this.id) {
                world.setBlockWithNotify(x, y, z, 0);
                d = (d + (double)x + 0.5) / 2.0;
                d1 = (d1 + (double)y + 0.5) / 2.0;
                d2 = (d2 + (double)z + 0.5) / 2.0;
            }
            world.newExplosion(null, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 5.0f, true, false);
            return true;
        }
        if (BlockBed.isBedOccupied(meta)) {
            EntityPlayer player1 = null;
            for (EntityPlayer p : world.players) {
                if (!p.isPlayerSleeping()) continue;
                ChunkCoordinates pos = p.bedChunkCoordinates;
                if (pos.x != x || pos.y != y || pos.z != z) continue;
                player1 = p;
            }
            if (player1 == null) {
                BlockBed.setBedOccupied(world, x, y, z, false);
            } else {
                player.sendTranslatedChatMessage("bed.occupied");
                return true;
            }
        }
        if (player.sleepInBedAt(x, y, z) == EnumSleepStatus.OK) {
            BlockBed.setBedOccupied(world, x, y, z, true);
            return true;
        }
        return true;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        this.setBounds();
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        int i1 = world.getBlockMetadata(x, y, z);
        int j1 = BlockBed.getDirectionFromMetadata(i1);
        if (BlockBed.isBlockFootOfBed(i1)) {
            if (world.getBlockId(x - headBlockToFootBlockMap[j1][0], y, z - headBlockToFootBlockMap[j1][1]) != this.id) {
                world.setBlockWithNotify(x, y, z, 0);
            }
        } else if (world.getBlockId(x + headBlockToFootBlockMap[j1][0], y, z + headBlockToFootBlockMap[j1][1]) != this.id) {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    private void setBounds() {
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    }

    public static int getDirectionFromMetadata(int i) {
        return i & 3;
    }

    public static boolean isBlockFootOfBed(int i) {
        return (i & 8) != 0;
    }

    public static boolean isBedOccupied(int i) {
        return (i & 4) != 0;
    }

    public static void setBedOccupied(World world, int i, int j, int k, boolean flag) {
        int l = world.getBlockMetadata(i, j, k);
        l = flag ? (l |= 4) : (l &= 0xFFFFFFFB);
        world.setBlockMetadataWithNotify(i, j, k, l);
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinates(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        int j1 = BlockBed.getDirectionFromMetadata(i1);
        for (int k1 = 0; k1 <= 1; ++k1) {
            int l1 = i - headBlockToFootBlockMap[j1][0] * k1 - 1;
            int i2 = k - headBlockToFootBlockMap[j1][1] * k1 - 1;
            int j2 = l1 + 2;
            int k2 = i2 + 2;
            for (int l2 = l1; l2 <= j2; ++l2) {
                for (int i3 = i2; i3 <= k2; ++i3) {
                    if (!world.isBlockNormalCube(l2, j - 1, i3) || !world.isAirBlock(l2, j, i3) || !world.isAirBlock(l2, j + 1, i3)) continue;
                    if (l > 0) {
                        --l;
                        continue;
                    }
                    return new ChunkCoordinates(l2, j, i3);
                }
            }
        }
        return null;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Item.bed)};
    }

    @Override
    public int getPistonPushReaction() {
        return 1;
    }
}

