/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockFluidStill
extends BlockFluid {
    public BlockFluidStill(String key, int id, Material material) {
        super(key, id, material);
        this.setTicking(false);
        if (material == Material.lava) {
            this.setTicking(true);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        if (blockId == Side.TOP.getId()) {
            return;
        }
        if (world.getBlockId(x, y, z) == this.id) {
            this.func_30004_j(world, x, y, z);
        }
    }

    private void func_30004_j(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        world.editingBlocks = true;
        world.setBlockAndMetadata(i, j, k, this.id - 1, l);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.scheduleBlockUpdate(i, j, k, this.id - 1, this.tickRate());
        world.editingBlocks = false;
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.blockMaterial == Material.lava) {
            int l = rand.nextInt(3);
            for (int i1 = 0; i1 < l; ++i1) {
                int j1 = world.getBlockId(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1);
                if (j1 == 0) {
                    if (!this.func_301_k(world, x - 1, y, z) && !this.func_301_k(world, x + 1, y, z) && !this.func_301_k(world, x, y, z - 1) && !this.func_301_k(world, x, y, z + 1) && !this.func_301_k(world, x, y - 1, z) && !this.func_301_k(world, x, y + 1, z)) continue;
                    world.setBlockWithNotify(x, y, z, Block.fire.id);
                    return;
                }
                if (!Block.blocksList[j1].blockMaterial.blocksMotion()) continue;
                return;
            }
        }
    }

    private boolean func_301_k(World world, int i, int j, int k) {
        return world.getBlockMaterial(i, j, k).isFlammable();
    }
}

