/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.world.World;

public class BlockSand
extends Block {
    public static boolean fallInstantly = false;

    public BlockSand(String key, int id) {
        super(key, id, Material.sand);
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.tryToFall(world, x, y, z);
    }

    private void tryToFall(World world, int i, int j, int k) {
        int l = i;
        int i1 = j;
        int j1 = k;
        if (BlockSand.canFallBelow(world, l, i1 - 1, j1) && i1 >= 0) {
            int byte0 = 32;
            if (fallInstantly || !world.areBlocksLoaded(i - byte0, j - byte0, k - byte0, i + byte0, j + byte0, k + byte0)) {
                world.setBlockWithNotify(i, j, k, 0);
                while (BlockSand.canFallBelow(world, i, j - 1, k) && j > 0) {
                    --j;
                }
                if (j > 0) {
                    world.setBlockWithNotify(i, j, k, this.id);
                }
            } else {
                EntityFallingSand entityfallingsand = new EntityFallingSand(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, this.id);
                world.entityJoinedWorld(entityfallingsand);
            }
        }
    }

    @Override
    public int tickRate() {
        return 3;
    }

    public static boolean canFallBelow(World world, int i, int j, int k) {
        int blockId = world.getBlockId(i, j, k);
        if (blockId == 0) {
            return true;
        }
        if (blockId == Block.fire.id) {
            return true;
        }
        if (Block.hasTag(blockId, BlockTags.IS_WATER)) {
            return true;
        }
        return Block.hasTag(blockId, BlockTags.IS_LAVA);
    }
}

