/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockSaplingBase;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaBushy;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTreeTaigaTall;

public class BlockSaplingPine
extends BlockSaplingBase {
    public BlockSaplingPine(String key, int id) {
        super(key, id);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        super.updateTick(world, x, y, z, rand);
        int growthRate = 30;
        if (world.getBlockLightValue(x, y + 1, z) >= 9 && rand.nextInt(growthRate) == 0) {
            int l = world.getBlockMetadata(x, y, z);
            if ((l & 8) == 0) {
                world.setBlockMetadataWithNotify(x, y, z, l | 8);
            } else {
                this.growTree(world, x, y, z, rand);
            }
        }
    }

    @Override
    public void growTree(World world, int i, int j, int k, Random random) {
        WorldFeatureTreeTaigaTall treeBig = new WorldFeatureTreeTaigaTall(Block.leavesPine.id, Block.logPine.id);
        WorldFeatureTreeTaigaBushy treeSmall = new WorldFeatureTreeTaigaBushy(Block.leavesPine.id, Block.logPine.id);
        world.setBlock(i, j, k, 0);
        if (!((WorldFeature)treeSmall).generate(world, random, i, j, k) && !((WorldFeature)treeBig).generate(world, random, i, j, k)) {
            world.setBlock(i, j, k, this.id);
        }
    }
}

