/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.save.conversion.ChunkConverter;

public class TileEntityRecordPlayer
extends TileEntity {
    public int record;

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.record = nbttagcompound.getInteger("Record");
        byte expanded = nbttagcompound.getByte("Expanded");
        if (expanded == 0 && this.record >= 256) {
            this.record += Block.blocksList.length - 256;
        }
        if (this.record < Block.blocksList.length) {
            short[] id = new short[]{(short)this.record};
            byte[] meta = new byte[]{0};
            ChunkConverter.converters[0].convertBlocksAndMetadata(id, meta);
            this.record = id[0];
        }
    }

    @Override
    public void writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.record > 0) {
            nbttagcompound.putInt("Record", this.record);
            nbttagcompound.putByte("Expanded", (byte)1);
        }
    }
}

