/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.crafting.legacy.type;

import net.minecraft.core.crafting.legacy.CraftingManager;
import net.minecraft.core.crafting.legacy.recipe.IRecipe;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryCrafting;

public class RecipeShaped
implements IRecipe {
    public int recipeWidth;
    public int recipeHeight;
    public ItemStack[] recipeItems;
    public ItemStack recipeOutput;
    public boolean useAlternatives;
    public boolean countForMetadata;
    public boolean consumeContainerItem;
    public final int recipeOutputItemID;

    public RecipeShaped(int i, int j, ItemStack[] inputs, ItemStack output) {
        this.recipeOutputItemID = output.itemID;
        this.recipeWidth = i;
        this.recipeHeight = j;
        this.recipeItems = inputs;
        this.recipeOutput = output;
        this.useAlternatives = false;
        this.countForMetadata = true;
        this.consumeContainerItem = false;
    }

    public RecipeShaped(int i, int j, ItemStack[] inputs, ItemStack output, boolean useAlternatives, boolean countForMetadata) {
        this(i, j, inputs, output);
        this.useAlternatives = useAlternatives;
        this.countForMetadata = countForMetadata;
    }

    public RecipeShaped(int i, int j, ItemStack[] inputs, ItemStack output, boolean useAlternatives, boolean countForMetadata, boolean consumeContainingItem) {
        this(i, j, inputs, output);
        this.useAlternatives = useAlternatives;
        this.countForMetadata = countForMetadata;
        this.consumeContainerItem = consumeContainingItem;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public boolean matches(InventoryCrafting inventory) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.isRecipeMatching(inventory, i, j, true)) {
                    return true;
                }
                if (!this.isRecipeMatching(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRecipeMatching(InventoryCrafting inventory, int i, int j, boolean flag) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                ItemStack itemstack1;
                int i1 = k - i;
                int j1 = l - j;
                ItemStack stack = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    stack = flag ? this.recipeItems[this.recipeWidth - i1 - 1 + j1 * this.recipeWidth] : this.recipeItems[i1 + j1 * this.recipeWidth];
                }
                if ((itemstack1 = inventory.getItemStackAt(k, l)) == null && stack == null) continue;
                int alternativeIndex = -1;
                if (this.useAlternatives && stack != null) {
                    for (int q = 0; q < CraftingManager.blockAlternatives.length; ++q) {
                        if (CraftingManager.blockAlternatives[q][0].id != stack.itemID) continue;
                        alternativeIndex = q;
                        break;
                    }
                }
                if (itemstack1 == null && stack != null || itemstack1 != null && stack == null) {
                    return false;
                }
                boolean idMatches = false;
                if (alternativeIndex != -1) {
                    for (int q = 0; q < CraftingManager.blockAlternatives[alternativeIndex].length; ++q) {
                        if (itemstack1.itemID != CraftingManager.blockAlternatives[alternativeIndex][q].id) continue;
                        idMatches = true;
                        break;
                    }
                } else if (stack.itemID == itemstack1.itemID) {
                    idMatches = true;
                }
                if (!idMatches) {
                    return false;
                }
                if (!this.countForMetadata || stack.getMetadata() == -1 || stack.getMetadata() == itemstack1.getMetadata()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.recipeOutput.itemID, this.recipeOutput.stackSize, this.recipeOutput.getMetadata());
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i = 0; i < inventorycrafting.getSizeInventory(); ++i) {
            ItemStack itemstack1 = inventorycrafting.getStackInSlot(i);
            if (itemstack1 == null) continue;
            inventorycrafting.decrStackSize(i, 1);
            if (this.consumeContainerItem || !itemstack1.getItem().hasContainerItem()) continue;
            inventorycrafting.setInventorySlotContents(i, new ItemStack(itemstack1.getItem().getContainerItem()));
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }
}

