/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.enums;

import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.animal.EntityAnimal;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.animal.EntityWaterAnimal;
import net.minecraft.core.entity.monster.IEnemy;

public enum EnumCreatureType {
    monster("monster", 0, IEnemy.class, 70, Material.air, false),
    creature("creature", 1, EntityAnimal.class, 15, Material.air, true),
    waterCreature("waterCreature", 2, EntityWaterAnimal.class, 5, Material.water, true),
    ambientCreature("ambient", 3, EntityFireflyCluster.class, 2, Material.air, true);

    private final Class<?> creatureClass;
    private final int maxNumberOfCreature;
    private final Material creatureMaterial;
    private final boolean isPeacefulCreature;

    private EnumCreatureType(String name, int id, Class<?> entityClass, int maxNumberOfCreature, Material materialToSpawnIn, boolean isPeacefulCreature) {
        this.creatureClass = entityClass;
        this.maxNumberOfCreature = maxNumberOfCreature;
        this.creatureMaterial = materialToSpawnIn;
        this.isPeacefulCreature = isPeacefulCreature;
    }

    public Class<?> getCreatureClass() {
        return this.creatureClass;
    }

    public int getMaxNumberOfCreature() {
        return this.maxNumberOfCreature;
    }

    public Material getCreatureMaterial() {
        return this.creatureMaterial;
    }

    public boolean getPeacefulCreature() {
        return this.isPeacefulCreature;
    }
}

