/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemComplex;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet131MapData;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.saveddata.maps.ItemMapSavedData;

public class ItemMap
extends ItemComplex {
    protected ItemMap(String name, int id) {
        super(name, id);
    }

    public static ItemMapSavedData getOrCreateSavedData(short word0, World world) {
        String s = "map_" + word0;
        ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, "map_" + word0);
        if (mapData == null) {
            int mapId = world.getUniqueDataId("map");
            String stringId = "map_" + mapId;
            mapData = new ItemMapSavedData(stringId);
            world.setSavedData(stringId, mapData);
        }
        return mapData;
    }

    public ItemMapSavedData getOrCreateSavedData(ItemStack stack, World world) {
        String s = "map_" + stack.getMetadata();
        ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, "map_" + stack.getMetadata());
        if (mapData == null) {
            stack.setMetadata(world.getUniqueDataId("map"));
            String s1 = "map_" + stack.getMetadata();
            mapData = new ItemMapSavedData(s1);
            mapData.x = world.getLevelData().getSpawnX();
            mapData.z = world.getLevelData().getSpawnZ();
            mapData.scale = (byte)3;
            mapData.dimension = (byte)world.dimension.id;
            mapData.setDirty();
            world.setSavedData(s1, mapData);
        }
        return mapData;
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (world.getBlockId(blockX, blockY, blockZ) == Block.flag.id) {
            TileEntityFlag flag;
            ItemMapSavedData mapData = (ItemMapSavedData)world.getSavedData(ItemMapSavedData.class, "map_" + itemstack.getMetadata());
            boolean canCreateMap = mapData.createNewWaypoint(flag = (TileEntityFlag)world.getBlockTileEntity(blockX, blockY, blockZ));
            if (!canCreateMap) {
                entityplayer.sendTranslatedChatMessage("flag.full");
            }
            return canCreateMap;
        }
        return false;
    }

    public void update(World world, Entity entity, ItemMapSavedData data) {
        if (world.dimension.id != data.dimension) {
            return;
        }
        int mapWidth = 128;
        int mapHeight = 128;
        int blocksPerPixel = 1 << data.scale;
        int mapCenterX = data.x;
        int mapCenterZ = data.z;
        int entityOnMapX = MathHelper.floor_double(entity.x - (double)mapCenterX) / blocksPerPixel + 64;
        int entityOnMapZ = MathHelper.floor_double(entity.z - (double)mapCenterZ) / blocksPerPixel + 64;
        int discoverRadius = 128 / blocksPerPixel;
        if (world.worldType.hasCeiling()) {
            discoverRadius /= 2;
        }
        ++data.step;
        for (int x = entityOnMapX - discoverRadius + 1; x < entityOnMapX + discoverRadius; ++x) {
            if ((x & 0xF) != (data.step & 0xF)) continue;
            int minZ = 255;
            int maxZ = 0;
            double previousPixelHeight = 0.0;
            boolean previousChunkLoaded = false;
            for (int z = entityOnMapZ - discoverRadius - 1; z < entityOnMapZ + discoverRadius; ++z) {
                byte finalColor;
                byte currentColor;
                if (x < 0 || z < -1 || x >= 128 || z >= 128) continue;
                int distX = x - entityOnMapX;
                int distZ = z - entityOnMapZ;
                boolean flag = distX * distX + distZ * distZ > (discoverRadius - 2) * (discoverRadius - 2);
                int blockX = (mapCenterX / blocksPerPixel + x - 64) * blocksPerPixel;
                int blockZ = (mapCenterZ / blocksPerPixel + z - 64) * blocksPerPixel;
                if (!world.isBlockLoaded(blockX, world.getHeightBlocks() / 2, blockZ)) {
                    previousChunkLoaded = false;
                    continue;
                }
                int[] blockCounts = new int[Block.blocksList.length];
                Chunk chunk = world.getChunkFromBlockCoords(blockX, blockZ);
                int blockInChunkX = blockX & 0xF;
                int blockInChunkZ = blockZ & 0xF;
                int waterDepth = 0;
                double pixelHeight = 0.0;
                if (world.worldType.hasCeiling()) {
                    int rand = blockX + blockZ * 231871;
                    if (((rand = rand * rand * 31287121 + rand * 11) >> 20 & 1) == 0) {
                        int n = Block.dirt.id;
                        blockCounts[n] = blockCounts[n] + 10;
                    } else {
                        int n = Block.stone.id;
                        blockCounts[n] = blockCounts[n] + 10;
                    }
                    pixelHeight = 100.0;
                } else {
                    for (int i = 0; i < blocksPerPixel; ++i) {
                        for (int j = 0; j < blocksPerPixel; ++j) {
                            int height = chunk.getHeightValue(i + blockInChunkX, j + blockInChunkZ) + 1;
                            int id = 0;
                            if (height > 1) {
                                boolean flag1 = false;
                                do {
                                    flag1 = true;
                                    id = chunk.getBlockID(i + blockInChunkX, height - 1, j + blockInChunkZ);
                                    if (id == 0) {
                                        flag1 = false;
                                    } else if (height > 0 && id > 0 && Block.blocksList[id].blockMaterial.color == MaterialColor.none) {
                                        flag1 = false;
                                    }
                                    if (flag1) continue;
                                    id = chunk.getBlockID(i + blockInChunkX, --height - 1, j + blockInChunkZ);
                                } while (!flag1);
                                if (id != 0 && Block.blocksList[id].blockMaterial.isLiquid()) {
                                    int i7 = height - 1;
                                    int k7 = 0;
                                    do {
                                        k7 = chunk.getBlockID(i + blockInChunkX, i7--, j + blockInChunkZ);
                                        ++waterDepth;
                                    } while (i7 > 0 && k7 != 0 && Block.blocksList[k7].blockMaterial.isLiquid());
                                }
                            }
                            pixelHeight += (double)height / (double)(blocksPerPixel * blocksPerPixel);
                            int n = id;
                            blockCounts[n] = blockCounts[n] + 1;
                        }
                    }
                }
                waterDepth /= blocksPerPixel * blocksPerPixel;
                int max = 0;
                int id = 0;
                for (int i = 0; i < Block.blocksList.length; ++i) {
                    if (blockCounts[i] <= max) continue;
                    id = i;
                    max = blockCounts[i];
                }
                double heightDifference = (pixelHeight - previousPixelHeight) * 4.0 / (double)(blocksPerPixel + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int brightness = 1;
                if (heightDifference > 0.6) {
                    brightness = 2;
                }
                if (heightDifference < -0.6) {
                    brightness = 0;
                }
                int colorIndex = 0;
                if (id > 0) {
                    MaterialColor mapcolor = Block.blocksList[id].blockMaterial.color;
                    if (mapcolor == MaterialColor.water) {
                        double d3 = (double)waterDepth * 0.1 + (double)(x + z & 1) * 0.2;
                        brightness = 1;
                        if (d3 < 0.5) {
                            brightness = 2;
                        }
                        if (d3 > 0.9) {
                            brightness = 0;
                        }
                    }
                    colorIndex = mapcolor.id;
                }
                previousPixelHeight = pixelHeight;
                if (!previousChunkLoaded) {
                    previousChunkLoaded = true;
                    continue;
                }
                if (z < 0 || distX * distX + distZ * distZ >= discoverRadius * discoverRadius || flag && (x + z & 1) == 0 || (currentColor = data.colors[x + z * 128]) == (finalColor = (byte)(colorIndex * 4 + brightness))) continue;
                if (minZ > z) {
                    minZ = z;
                }
                if (maxZ < z) {
                    maxZ = z;
                }
                data.colors[x + z * 128] = finalColor;
            }
            if (minZ > maxZ) continue;
            data.setDirty(x, minZ, maxZ);
        }
    }

    @Override
    public void inventoryTick(ItemStack itemstack, World world, Entity entity, int i, boolean flag) {
        if (world.isClientSide) {
            return;
        }
        ItemMapSavedData mapData = this.getOrCreateSavedData(itemstack, world);
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            mapData.tickCarriedBy(entityplayer, itemstack);
        }
        if (flag) {
            this.update(world, entity, mapData);
        }
    }

    @Override
    public void onCraftedBy(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        itemstack.setMetadata(world.getUniqueDataId("map"));
        String s = "map_" + itemstack.getMetadata();
        ItemMapSavedData mapdata = new ItemMapSavedData(s);
        world.setSavedData(s, mapdata);
        mapdata.x = MathHelper.floor_double(entityplayer.x);
        mapdata.z = MathHelper.floor_double(entityplayer.z);
        mapdata.scale = (byte)3;
        mapdata.dimension = (byte)world.dimension.id;
        mapdata.setDirty();
    }

    @Override
    public Packet sendPacketData(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        ItemMapSavedData itemMapSavedData = this.getOrCreateSavedData(itemstack, world);
        byte[] mapDataBytes = itemMapSavedData.getMapDataBytes(itemstack, world, entityplayer);
        if (mapDataBytes == null) {
            return null;
        }
        return new Packet131MapData((short)Item.map.id, (short)itemstack.getMetadata(), mapDataBytes, itemMapSavedData.mapWaypoints);
    }

    @Override
    public String getTranslatedName(ItemStack itemstack) {
        return super.getTranslatedName(itemstack) + " #" + itemstack.getMetadata();
    }
}

