/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;

public class ItemQuiver
extends Item {
    public ItemQuiver(String name, int id) {
        super(name, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(192);
    }

    @Override
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Override
    public ItemStack onInventoryInteract(EntityPlayer player, Slot slot, ItemStack stackInSlot, boolean isItemGrabbed) {
        ItemStack quiverItem = isItemGrabbed ? player.inventory.getHeldItemStack() : stackInSlot;
        int totalSpace = this.getMaxDamage();
        int arrowCount = this.getArrowCount(quiverItem);
        int freeSpace = totalSpace - arrowCount;
        if (isItemGrabbed) {
            int amount;
            if (stackInSlot == null) {
                ItemStack arrowStack;
                int amount2 = Math.min(64, arrowCount);
                if (amount2 > 0 && slot.canPutStackInSlot(arrowStack = new ItemStack(Item.ammoArrow, amount2, 0))) {
                    this.setArrowCount(quiverItem, arrowCount - amount2);
                    stackInSlot = arrowStack;
                }
            } else if (stackInSlot != null && stackInSlot.itemID == Item.ammoArrow.id && (amount = Math.min(freeSpace, stackInSlot.stackSize)) > 0) {
                this.setArrowCount(quiverItem, arrowCount + amount);
                stackInSlot.stackSize -= amount;
            }
        } else {
            int amount;
            ItemStack grabbedItem = player.inventory.getHeldItemStack();
            if (grabbedItem != null && grabbedItem.itemID == Item.ammoArrow.id) {
                int amount3 = Math.min(grabbedItem.stackSize, freeSpace);
                if (amount3 > 0) {
                    grabbedItem.stackSize -= amount3;
                    this.setArrowCount(quiverItem, arrowCount + amount3);
                    if (grabbedItem.stackSize <= 0) {
                        player.inventory.setHeldItemStack(null);
                    }
                }
            } else if (grabbedItem == null && (amount = Math.min(64, arrowCount)) > 0) {
                this.setArrowCount(quiverItem, arrowCount - amount);
                player.inventory.setHeldItemStack(new ItemStack(Item.ammoArrow, amount, 0));
            }
        }
        return stackInSlot;
    }

    private int getArrowCount(ItemStack stack) {
        return stack.getMaxDamage() - stack.getMetadata();
    }

    private void setArrowCount(ItemStack stack, int count) {
        stack.setMetadata(stack.getMaxDamage() - count);
    }

    @Override
    public boolean showFullDurability() {
        return true;
    }
}

