/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.block.Block;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;

public class SetBlockCommand
extends Command {
    public SetBlockCommand() {
        super("setblock", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        int blockId;
        int temp;
        int blockIDOffset;
        int z2;
        int y2;
        int x2;
        if (args.length < 4) {
            return false;
        }
        if (!sender.isPlayer()) {
            throw new CommandError("Must be sent by a player!");
        }
        int x1 = Integer.parseInt(args[0]);
        int y1 = Integer.parseInt(args[1]);
        int z1 = Integer.parseInt(args[2]);
        if (args.length == 4) {
            x2 = x1;
            y2 = y1;
            z2 = z1;
            blockIDOffset = 3;
        } else if (args.length == 7) {
            x2 = Integer.parseInt(args[3]);
            y2 = Integer.parseInt(args[4]);
            z2 = Integer.parseInt(args[5]);
            blockIDOffset = 6;
        } else {
            return false;
        }
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (z1 > z2) {
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        String[] id = args[blockIDOffset].split(":");
        int meta = 0;
        if (id.length >= 2) {
            meta = Integer.parseInt(id[1]);
        }
        if ((blockId = SetBlockCommand.getBlock(id[0], meta)) == -1) {
            return false;
        }
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                for (int y = y1; y <= y2; ++y) {
                    sender.getPlayer().world.setBlockAndMetadataWithNotify(x, y, z, blockId, meta);
                }
            }
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/setblock <x> <y> <z> <block>");
        sender.sendMessage("/setblock <x1> <y1> <z1> <x2> <y2> <z2> <block>");
    }

    public static Block getBlock(int id) {
        return Block.blocksList[id];
    }

    public static int getBlock(String id, int meta) {
        try {
            int i = Integer.parseInt(id);
            if (i == 0 || Block.blocksList[i] != null) {
                return i;
            }
            return -1;
        }
        catch (Exception e) {
            String id2 = "tile." + id;
            for (Block block : Block.blocksList) {
                if (block == null) continue;
                if (block.getKey().equalsIgnoreCase(id)) {
                    return block.id;
                }
                if (!block.getKey().equalsIgnoreCase(id2)) continue;
                return block.id;
            }
            return -1;
        }
    }
}

