/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import java.util.Set;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandError;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.LocationTarget;
import net.minecraft.core.net.command.PlayerCommandSender;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.world.World;

public class SummonCommand
extends Command {
    public SummonCommand() {
        super("summon", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (args[0].equalsIgnoreCase("list")) {
            StringBuilder builder = new StringBuilder().append(TextFormatting.LIGHT_GRAY).append("Entities: ").append(TextFormatting.WHITE);
            int i = 0;
            for (String string : EntityDispatcher.keyToClassMap.keySet()) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(string);
                ++i;
            }
            sender.sendMessage(builder.toString());
            return true;
        }
        Set<String> keySet = EntityDispatcher.keyToClassMap.keySet();
        String entityID = args[0];
        Class<? extends Entity> entityClass = null;
        for (String str : keySet) {
            if (!str.equalsIgnoreCase(entityID)) continue;
            entityID = str;
            entityClass = EntityDispatcher.keyToClassMap.get(entityID);
        }
        if (entityClass == null) {
            throw new CommandError("Could not find entity \"" + entityID + "\"");
        }
        LocationTarget location = new LocationTarget(handler, sender);
        int count = 1;
        int offset = 1;
        if (args.length > 1) {
            offset += location.parse(args, offset);
        }
        if (args.length > offset) {
            count = Integer.parseInt(args[offset]);
        }
        if (handler.isServer()) {
            count = Math.min(count, handler.asServer().minecraftServer.summonLimit);
        }
        for (int i = 0; i < count; ++i) {
            Entity entity = SummonCommand.createEntity(entityClass, location.getWorld());
            entity.spawnInit();
            entity.moveTo(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
            location.getWorld().entityJoinedWorld(entity);
        }
        handler.sendCommandFeedback(sender, "Summoned " + count + " " + entityID + " at " + location);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/summon <entity> <position> <count>");
        }
    }

    public static Entity createEntity(Class<? extends Entity> entityClass, World world) {
        try {
            return entityClass.getConstructor(World.class).newInstance(world);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandError("Could not create Entity!");
        }
    }
}

