/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.entity.entries;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityBobber;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.Packet23VehicleSpawn;
import net.minecraft.core.world.World;
import net.minecraft.server.entity.EntityTracker;
import net.minecraft.server.entity.EntityTrackerEntry;
import org.jetbrains.annotations.NotNull;

public class BobberNetEntry
implements IVehicleEntry<EntityBobber>,
ITrackedEntry<EntityBobber> {
    @Override
    @NotNull
    public Class<EntityBobber> getAppliedClass() {
        return EntityBobber.class;
    }

    @Override
    public int getTrackingDistance() {
        return 64;
    }

    @Override
    public int getPacketDelay() {
        return 5;
    }

    @Override
    public boolean sendMotionUpdates() {
        return true;
    }

    @Override
    public void onEntityTracked(EntityTracker tracker, EntityTrackerEntry trackerEntry, EntityBobber trackedObject) {
    }

    @Override
    public Entity getEntity(World world, double x, double y, double z, int metadata, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        EntityBobber bobber = new EntityBobber(world, x, y, z);
        if (owner != null) {
            bobber.player = (EntityPlayer)owner;
            ((EntityPlayer)owner).bobberEntity = bobber;
        }
        return bobber;
    }

    @Override
    public Packet23VehicleSpawn getSpawnPacket(EntityTrackerEntry tracker, EntityBobber bobber) {
        return new Packet23VehicleSpawn(bobber, 0, bobber.player == null ? -1 : bobber.player.id);
    }
}

