/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet138PlayerList
extends Packet {
    public String[] players;
    public String[] scores;
    public int count;

    public Packet138PlayerList() {
    }

    public Packet138PlayerList(int playerCount, String[] players, String[] scores) {
        this.count = playerCount;
        this.players = players;
        this.scores = scores;
    }

    @Override
    public void readPacketData(DataInputStream in) throws IOException {
        this.count = in.readInt();
        this.players = new String[this.count];
        this.scores = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.players[i] = Packet138PlayerList.readString(in, 1024);
            this.scores[i] = Packet138PlayerList.readString(in, 1024);
        }
    }

    @Override
    public void writePacketData(DataOutputStream out) throws IOException {
        out.writeInt(this.count);
        for (int i = 0; i < this.count; ++i) {
            Packet138PlayerList.writeString(this.players[i], out);
            Packet138PlayerList.writeString(this.scores[i], out);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePlayerList(this);
    }

    @Override
    public int getPacketSize() {
        int i;
        int size = 4;
        for (i = 0; i < this.scores.length; ++i) {
            size += this.scores[i].length();
        }
        for (i = 0; i < this.players.length; ++i) {
            size += this.players[i].length();
        }
        return size;
    }
}

