/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet5PlayerInventory
extends Packet {
    public int entityID;
    public int slot;
    public int itemID;
    public int itemDamage;
    public CompoundTag itemData;

    public Packet5PlayerInventory() {
    }

    public Packet5PlayerInventory(int entityID, int slot, ItemStack itemstack) {
        this.entityID = entityID;
        this.slot = slot;
        if (itemstack == null) {
            this.itemID = -1;
            this.itemDamage = 0;
            this.itemData = new CompoundTag();
        } else {
            this.itemID = itemstack.itemID;
            this.itemDamage = itemstack.getMetadata();
            this.itemData = itemstack.getData();
        }
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityID = dis.readInt();
        this.slot = dis.readShort();
        this.itemID = dis.readShort();
        this.itemDamage = dis.readShort();
        this.itemData = Packet5PlayerInventory.readCompressedCompoundTag(dis);
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityID);
        dos.writeShort(this.slot);
        dos.writeShort(this.itemID);
        dos.writeShort(this.itemDamage);
        Packet5PlayerInventory.writeCompressedCompoundTag(this.itemData, dos);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePlayerInventory(this);
    }

    @Override
    public int getPacketSize() {
        return 8;
    }
}

