/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet75RecipeSync
extends Packet {
    public String recipe;
    public long maxRecipes;

    public Packet75RecipeSync(RecipeEntryBase<?, ?, ?> recipe, long maxRecipes) {
        this.recipe = DataLoader.serializeRecipe(recipe);
        this.maxRecipes = maxRecipes;
    }

    public Packet75RecipeSync() {
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.recipe = dis.readUTF();
        this.maxRecipes = dis.readLong();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.recipe);
        dos.writeLong(this.maxRecipes);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleSyncedRecipe(this);
    }

    @Override
    public int getPacketSize() {
        return this.recipe.getBytes().length;
    }
}

