/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.slot.Slot;

public class ContainerDispenser
extends Container {
    public TileEntityDispenser tileEntity;
    private int dispenserSlotsStart;
    private int inventorySlotsStart;
    private int hotbarSlotsStart;

    public ContainerDispenser(IInventory iinventory, TileEntityDispenser tileentitydispenser) {
        this.tileEntity = tileentitydispenser;
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 3; ++l) {
                this.addSlot(new Slot(tileentitydispenser, l + i * 3, 62 + l * 18, 17 + i * 18));
            }
        }
        for (int j = 0; j < 3; ++j) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot(iinventory, i1 + j * 9 + 9, 8 + i1 * 18, 84 + j * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot(iinventory, k, 8 + k * 18, 142));
        }
        this.dispenserSlotsStart = 0;
        this.inventorySlotsStart = 9;
        this.hotbarSlotsStart = 36;
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.tileEntity.canInteractWith(entityplayer);
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= this.dispenserSlotsStart && slot.id < this.inventorySlotsStart) {
            return this.getSlots(this.dispenserSlotsStart, 9, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.id >= this.inventorySlotsStart && slot.id < this.hotbarSlotsStart) {
                return this.getSlots(this.inventorySlotsStart, 27, false);
            }
            if (slot.id >= this.hotbarSlotsStart) {
                return this.getSlots(this.hotbarSlotsStart, 9, false);
            }
        }
        if (action == InventoryAction.MOVE_SIMILAR && slot.id >= this.inventorySlotsStart) {
            return this.getSlots(this.inventorySlotsStart, 36, false);
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        if (slot.id >= this.dispenserSlotsStart && slot.id < this.inventorySlotsStart) {
            return this.getSlots(this.inventorySlotsStart, 36, false);
        }
        return this.getSlots(this.dispenserSlotsStart, 9, false);
    }
}

