/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.slot;

import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.block.Block;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tool.ItemToolHoe;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.item.tool.ItemToolSword;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.InventoryCrafting;
import net.minecraft.core.player.inventory.slot.Slot;

public class SlotCrafting
extends Slot {
    private final IInventory craftMatrix;
    private EntityPlayer thePlayer;

    public SlotCrafting(EntityPlayer entityplayer, IInventory iinventory, IInventory iinventory1, int i, int j, int k) {
        super(iinventory1, i, j, k);
        this.thePlayer = entityplayer;
        this.craftMatrix = iinventory;
    }

    @Override
    public boolean canPutStackInSlot(ItemStack itemstack) {
        return false;
    }

    @Override
    public void onPickupFromSlot(ItemStack itemStack) {
        itemStack.onCrafting(this.thePlayer.world, this.thePlayer);
        Item item = itemStack.getItem();
        if (item.id == Block.workbench.id) {
            this.thePlayer.addStat(AchievementList.BUILD_WORKBENCH, 1);
        }
        if (item.id == Block.furnaceStoneIdle.id) {
            this.thePlayer.addStat(AchievementList.BUILD_FURNACE, 1);
        }
        if (item.id == Item.foodBread.id) {
            this.thePlayer.addStat(AchievementList.MAKE_BREAD, 1);
        }
        if (item.id == Item.foodCake.id) {
            this.thePlayer.addStat(AchievementList.BAKE_CAKE, 1);
        }
        if (item.id == Item.handcannonUnloaded.id) {
            this.thePlayer.addStat(AchievementList.CRAFT_HANDCANNON, 1);
        }
        if (item instanceof ItemToolHoe) {
            this.thePlayer.addStat(AchievementList.BUILD_HOE, 1);
        }
        if (item instanceof ItemToolSword) {
            this.thePlayer.addStat(AchievementList.BUILD_SWORD, 1);
        }
        if (item instanceof ItemToolPickaxe) {
            ItemToolPickaxe itemToolPickaxe = (ItemToolPickaxe)item;
            if (itemToolPickaxe.getMaterial().getMiningLevel() > 0) {
                this.thePlayer.addStat(AchievementList.BUILD_BETTER_PICKAXE, 1);
            }
            this.thePlayer.addStat(AchievementList.BUILD_PICKAXE, 1);
        }
        if (itemStack.itemID == Item.armorBootsChainmail.id || itemStack.itemID == Item.armorHelmetChainmail.id || itemStack.itemID == Item.armorChestplateChainmail.id || itemStack.itemID == Item.armorLeggingsChainmail.id) {
            this.thePlayer.addStat(AchievementList.REPAIR_ARMOR, 1);
        }
        Registries.RECIPES.onCraftResult((InventoryCrafting)this.craftMatrix);
    }

    @Override
    public boolean enableDragAndPickup() {
        return false;
    }

    @Override
    public boolean allowItemInteraction() {
        return false;
    }
}

