/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;

public class Dimension {
    public int id;
    public final String languageKey;
    public final Dimension homeDim;
    public WorldType defaultWorldType;
    public final float worldScale;
    public final int portalBlockId;
    private static final Map<Integer, Dimension> dimensionList = new HashMap<Integer, Dimension>();
    public static final Dimension overworld = new Dimension("overworld", null, 1.0f, -1).setDefaultWorldType(WorldTypes.OVERWORLD_DEFAULT);
    public static final Dimension nether = new Dimension("hell", overworld, 0.125f, Block.portalNether.id).setDefaultWorldType(WorldTypes.NETHER_DEFAULT);
    public static final Dimension paradise = new Dimension("paradise", overworld, 8.0f, Block.portalParadise.id).setDefaultWorldType(WorldTypes.PARADISE_DEFAULT);

    public Dimension(String languageKey, Dimension homeDim, float worldScale, int portalBlockId) {
        this.languageKey = languageKey;
        this.homeDim = homeDim;
        this.worldScale = worldScale;
        this.portalBlockId = portalBlockId;
    }

    public DimensionData getDimensionData(World world) {
        if (world.dimension == this) {
            return world.dimensionData;
        }
        DimensionData dimensionData = world.saveHandler.getDimensionData(this.id);
        if (dimensionData == null) {
            dimensionData = new DimensionData(this.defaultWorldType);
        }
        return dimensionData;
    }

    public Dimension setDefaultWorldType(WorldType defaultWorldType) {
        this.defaultWorldType = defaultWorldType;
        return this;
    }

    public boolean canPortal(Dimension dim) {
        if (this.homeDim == null) {
            return true;
        }
        return dim == this.homeDim;
    }

    public static float getCoordScale(Dimension oldDim, Dimension newDim) {
        if (oldDim.homeDim == newDim) {
            return 1.0f / oldDim.worldScale;
        }
        if (newDim.homeDim == oldDim) {
            return newDim.worldScale;
        }
        return 1.0f;
    }

    public String getTranslatedName() {
        return I18n.getInstance().translateNameKey("dimension." + this.languageKey);
    }

    public String toString() {
        return "Dimension: [ ID: " + this.id + " Name: " + this.getTranslatedName() + " ]";
    }

    public static Map<Integer, Dimension> getDimensionList() {
        return Collections.unmodifiableMap(dimensionList);
    }

    public static void registerDimension(int id, Dimension dimension) throws IllegalArgumentException {
        if (dimensionList.containsKey(id)) {
            throw new IllegalArgumentException("Dimension with ID " + dimension.id + " is already registered!");
        }
        dimension.id = id;
        dimensionList.put(id, dimension);
    }

    static {
        Dimension.registerDimension(0, overworld);
        Dimension.registerDimension(1, nether);
        Dimension.registerDimension(2, paradise);
    }
}

