/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureRichScorchedDirt
extends WorldFeature {
    private final int numberOfBlocks;

    @MethodParametersAnnotation(names={"numberOfBlocks"})
    public WorldFeatureRichScorchedDirt(int numberOfBlocks) {
        this.numberOfBlocks = numberOfBlocks;
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        for (int x1 = x - this.numberOfBlocks; x1 < x + this.numberOfBlocks; ++x1) {
            for (int y1 = y - 2; y1 <= y + 2; ++y1) {
                for (int z1 = z - this.numberOfBlocks; z1 < z + this.numberOfBlocks; ++z1) {
                    if (random.nextInt(8) != 0 || world.getBlockId(x1, y1, z1) != Block.dirtScorched.id) continue;
                    world.setBlock(x1, y1, z1, Block.dirtScorchedRich.id);
                }
            }
        }
        return true;
    }
}

