/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save.conversion;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.NbtIo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.save.conversion.ChunkConverter;
import net.minecraft.core.world.save.conversion.SaveConverterMCRegionBase;
import net.minecraft.core.world.save.mcregion.RegionFile;
import net.minecraft.core.world.save.mcregion.RegionFileCache;

public class SaveConverter19132To19133
extends SaveConverterMCRegionBase {
    @Override
    public int fromVersion() {
        return 19132;
    }

    @Override
    public int toVersion() {
        return 19133;
    }

    @Override
    int convertDimensionRegions(Dimension dimension, ArrayList<File> regionFiles, int conversionsPerformed, int totalConversions, ProgressListener progress) {
        Collections.sort(regionFiles);
        int progressValue = 0;
        int conversions = 0;
        for (File region : regionFiles) {
            progress.progressStagePercentage(progressValue);
            RegionFile regionFile = new RegionFile(region);
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    try {
                        DataOutputStream outputStream = regionFile.getChunkDataOutputStream(x, z);
                        DataInputStream inputStream = regionFile.getChunkDataInputStream(x, z);
                        if (inputStream == null) continue;
                        CompoundTag chunkData = NbtIo.read(inputStream);
                        byte[] ids = chunkData.getCompound("Level").getByteArray("Blocks");
                        byte[] expandedIds = new byte[65536];
                        for (int i = 0; i < ids.length; i += 128) {
                            System.arraycopy(ids, i, expandedIds, i * 2, 128);
                        }
                        short[] shortIds = new short[65536];
                        for (int i = 0; i < expandedIds.length; ++i) {
                            shortIds[i] = expandedIds[i];
                        }
                        byte[] nibbleData = chunkData.getCompound("Level").getByteArray("Data");
                        byte[] byteData = new byte[nibbleData.length * 2];
                        for (int i = 0; i < byteData.length; ++i) {
                            int nibbleIndex = i >> 1;
                            byteData[i] = (i & 1) == 0 ? (byte)(nibbleData[nibbleIndex] & 0xF) : (byte)(nibbleData[nibbleIndex] >> 4 & 0xF);
                        }
                        byte[] expandedByteData = new byte[65536];
                        for (int i = 0; i < byteData.length; i += 128) {
                            System.arraycopy(byteData, i, expandedByteData, i * 2, 128);
                        }
                        ChunkConverter.converters[0].convertBlocksAndMetadata(shortIds, expandedByteData);
                        byte[] skylightMap = chunkData.getCompound("Level").getByteArray("SkyLight");
                        byte[] skylightMapExtended = new byte[32768];
                        for (int i = 0; i < skylightMap.length; i += 64) {
                            System.arraycopy(skylightMap, i, skylightMapExtended, i * 2, 64);
                        }
                        byte[] blocklightMap = chunkData.getCompound("Level").getByteArray("BlockLight");
                        byte[] blocklightMapExtended = new byte[32768];
                        for (int i = 0; i < blocklightMap.length; i += 64) {
                            System.arraycopy(blocklightMap, i, blocklightMapExtended, i * 2, 64);
                        }
                        chunkData.getCompound("Level").putShortArray("Blocks", shortIds);
                        chunkData.getCompound("Level").putByteArray("Data", expandedByteData);
                        chunkData.getCompound("Level").putByteArray("SkyLight", skylightMapExtended);
                        chunkData.getCompound("Level").putByteArray("BlockLight", blocklightMapExtended);
                        NbtIo.write(chunkData, outputStream);
                        inputStream.close();
                        outputStream.close();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            progressValue = (int)Math.round(100.0 * (double)(conversionsPerformed + ++conversions) / (double)totalConversions);
        }
        RegionFileCache.flushCache();
        return conversions;
    }
}

