/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.indev.ChunkGeneratorIndev;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldTheme;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldType;
import net.minecraft.core.world.generate.chunk.indev.LevelGenerator;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldTypeOverworld;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManagerGeneric;

public class WorldTypeOverworldIndev
extends WorldTypeOverworld {
    public WorldTypeOverworldIndev(String languageKey) {
        super(languageKey, Weather.overworldClear, new WindManagerGeneric(), SeasonConfig.builder().withSingleSeason(Seasons.NULL).build());
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return 127;
    }

    @Override
    public int getOceanY() {
        return 64;
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return world.getBlockId(x, y, z) == Block.grass.id || world.getBlockId(x, y, z) == Block.sand.id || world.getBlockId(x, y, z) == Block.grassRetro.id;
    }

    @Override
    public void getInitialSpawnLocation(World world) {
        int x = 0;
        int y = 0;
        int z = 0;
        block0: while (true) {
            x = world.rand.nextInt(256);
            z = world.rand.nextInt(256);
            y = this.getMaxY();
            while (true) {
                if (y < this.getMinY()) continue block0;
                if (world.getBlockId(x, y + 1, z) == 0 && this.isValidSpawn(world, x, y, z)) break block0;
                --y;
            }
            break;
        }
        world.getLevelData().setSpawn(x, y, z);
        LevelGenerator.generateHouse(world);
    }

    @Override
    public void getRespawnLocation(World world) {
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.OVERWORLD_RETRO, 1.0, 1.0, 1.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorIndev(world, 256, this.getMaxY() + 1, 256, IndevWorldType.ISLAND, IndevWorldTheme.NORMAL);
    }

    @Override
    public float getCloudHeight() {
        return 108.0f;
    }
}

