/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.world.pathfinder.IdHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.EntityTrackerEntry;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class EntityTracker {
    public final Set<EntityTrackerEntry> trackedEntitySet = new HashSet<EntityTrackerEntry>();
    public final IdHashMap<EntityTrackerEntry> trackedEntityHashTable = new IdHashMap();
    public final MinecraftServer mcServer;
    public final int maxTrackingDistanceThreshold;
    public final int dimension;

    public EntityTracker(MinecraftServer minecraftserver, int dimId) {
        this.mcServer = minecraftserver;
        this.dimension = dimId;
        this.maxTrackingDistanceThreshold = minecraftserver.playerList.getMaxTrackingDistance();
    }

    public void trackEntity(Entity entity) {
        ITrackedEntry<Entity> trackedConfig = NetEntityHandler.getTrackedEntry(entity);
        if (trackedConfig != null) {
            EntityTrackerEntry trackerEntry = this.trackEntity(entity, trackedConfig.getTrackingDistance(), trackedConfig.getPacketDelay(), trackedConfig.sendMotionUpdates());
            trackedConfig.onEntityTracked(this, trackerEntry, entity);
        }
    }

    public EntityTrackerEntry trackEntity(Entity entity, int trackingDistance, int packetDelay, boolean shouldSendMotionUpdates) {
        if (trackingDistance > this.maxTrackingDistanceThreshold) {
            trackingDistance = this.maxTrackingDistanceThreshold;
        }
        if (this.trackedEntityHashTable.containsItem(entity.id)) {
            throw new IllegalStateException("Entity is already tracked!");
        }
        EntityTrackerEntry trackerEntry = new EntityTrackerEntry(entity, trackingDistance, packetDelay, shouldSendMotionUpdates);
        this.trackedEntitySet.add(trackerEntry);
        this.trackedEntityHashTable.add(entity.id, trackerEntry);
        trackerEntry.updatePlayerEntities(this.mcServer.getDimensionWorld((int)this.dimension).players);
        return trackerEntry;
    }

    public void untrackEntity(Entity entity) {
        EntityTrackerEntry entitytrackerentry;
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entity;
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                entitytrackerentry1.removeFromTrackedPlayers(entityplayermp);
            }
        }
        if ((entitytrackerentry = this.trackedEntityHashTable.remove(entity.id)) != null) {
            this.trackedEntitySet.remove(entitytrackerentry);
            entitytrackerentry.sendDestroyEntityPacketToTrackedPlayers();
        }
    }

    public void tick() {
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.tick(this.mcServer.getDimensionWorld((int)this.dimension).players);
            if (!entitytrackerentry.playerEntitiesUpdated || !(entitytrackerentry.trackedEntity instanceof EntityPlayerMP)) continue;
            arraylist.add(entitytrackerentry.trackedEntity);
        }
        for (int i = 0; i < arraylist.size(); ++i) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)arraylist.get(i);
            for (EntityTrackerEntry entitytrackerentry1 : this.trackedEntitySet) {
                if (entitytrackerentry1.trackedEntity == entityplayermp) continue;
                entitytrackerentry1.updatePlayerEntity(entityplayermp);
            }
        }
    }

    public void sendPacketToTrackedPlayers(Entity entity, Packet packet) {
        EntityTrackerEntry entitytrackerentry = this.trackedEntityHashTable.get(entity.id);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayers(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Entity entity, Packet packet) {
        EntityTrackerEntry entitytrackerentry = this.trackedEntityHashTable.get(entity.id);
        if (entitytrackerentry != null) {
            entitytrackerentry.sendPacketToTrackedPlayersAndTrackedEntity(packet);
        }
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP entityplayermp) {
        for (EntityTrackerEntry entitytrackerentry : this.trackedEntitySet) {
            entitytrackerentry.removeTrackedPlayerSymmetric(entityplayermp);
        }
    }
}

