#version 120

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float intensity;

varying vec2 texcoord;

void main()
{
	vec3 color = texture2D(colortex0, texcoord).rgb;
	float depth = texture2D(depthtex0, texcoord).r;

	depth = (depth - 0.45) * 10;

	color = mix(color, vec3(depth), intensity);

	gl_FragColor = vec4(color, 1.0);
}