/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiBlank;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupCloseListener;
import net.minecraft.core.net.command.TextFormatting;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class GuiException {
    public static GuiPopup create(GuiScreen parent, Throwable e, Minecraft mc) {
        StackTraceElement[] trace;
        int scale = Math.max(mc.resolution.scale, 1);
        StringBuilder s = new StringBuilder("Minecraft ran into an unexpected problem!\n\n");
        s.append("To prevent more problems, the current game has quit, but you can try to keep playing.\n\n");
        s.append("If you wish to report this, please copy this entire text and post it on the forum thread at ").append(TextFormatting.LIGHT_BLUE).append("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/3106066-better-than-adventure-for-beta-1-7-3-timely").append(TextFormatting.WHITE).append(", or join the Discord server at ").append(TextFormatting.LIGHT_BLUE).append("https://betterthanadventure.net/discord").append(TextFormatting.WHITE).append(" and post it in ").append(TextFormatting.LIGHT_BLUE).append("#bug-reports").append(TextFormatting.WHITE).append(".\n\n");
        try {
            s.append(TextFormatting.WHITE).append("Generated ").append(new SimpleDateFormat().format(new Date())).append("\n\n");
            s.append("Minecraft: Better than Adventure! ").append(Minecraft.VERSION).append("\n");
            s.append("OS: ").append(System.getProperty("os.name")).append(" (").append(System.getProperty("os.arch")).append(") version ").append(System.getProperty("os.version")).append("\n");
            s.append("Java: ").append(System.getProperty("java.version")).append(", ").append(System.getProperty("java.vendor")).append("\n");
            s.append("VM: ").append(System.getProperty("java.vm.name")).append(" (").append(System.getProperty("java.vm.info")).append("), ").append(System.getProperty("java.vm.vendor")).append("\n");
            s.append("LWJGL: ").append(Sys.getVersion()).append("\n");
            s.append("OpenGL: ").append(GL11.glGetString((int)7937)).append(" version ").append(GL11.glGetString((int)7938)).append(", ").append(GL11.glGetString((int)7936)).append("\n\n");
        }
        catch (Throwable throwable) {
            s.append("[failed to get system properties (").append(throwable).append(")]\n\n");
        }
        s.append(TextFormatting.RED).append(e);
        for (StackTraceElement traceElement : trace = e.getStackTrace()) {
            s.append("\n    at ").append(traceElement);
        }
        s.append(TextFormatting.WHITE);
        GuiPopup popup = new PopupBuilder(parent, 860 / scale).withLabel("gui.exception.label.exception_occurred").withMessageBox("gui.exception.list", 400 / scale, s.toString(), 860 / scale / mc.fontRenderer.getCharWidth('m')).withButtonGroup("gui.exception.choice", new String[]{"gui.exception.button.back", "gui.exception.button.copy_error"}, new int[]{0, 1}).withOnCloseListener(new PopupListener(mc, s.toString().replaceAll("\u00a7[0-9a-f|klmnor]", ""))).build();
        return popup;
    }

    public static GuiPopup createFatal(Throwable e, Minecraft mc) {
        StackTraceElement[] trace;
        int scale = Math.max(mc.resolution.scale, 1);
        StringBuilder s = new StringBuilder("Minecraft ran into an unexpected problem that it cannot recover from!\n\n");
        s.append("The current game has quit, please restart the game.\n\n");
        s.append("If you wish to report this, please copy this entire text and post it on the forum thread at ").append(TextFormatting.LIGHT_BLUE).append("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/3106066-better-than-adventure-for-beta-1-7-3-timely").append(TextFormatting.WHITE).append(", or join the Discord server at ").append(TextFormatting.LIGHT_BLUE).append("https://betterthanadventure.net/discord").append(TextFormatting.WHITE).append(" and post it in ").append(TextFormatting.LIGHT_BLUE).append("#bug-reports").append(TextFormatting.WHITE).append(".\n\n");
        try {
            s.append(TextFormatting.WHITE).append("Generated ").append(new SimpleDateFormat().format(new Date())).append("\n\n");
            s.append("Minecraft: Better than Adventure! ").append(Minecraft.VERSION).append("\n");
            s.append("OS: ").append(System.getProperty("os.name")).append(" (").append(System.getProperty("os.arch")).append(") version ").append(System.getProperty("os.version")).append("\n");
            s.append("Java: ").append(System.getProperty("java.version")).append(", ").append(System.getProperty("java.vendor")).append("\n");
            s.append("VM: ").append(System.getProperty("java.vm.name")).append(" (").append(System.getProperty("java.vm.info")).append("), ").append(System.getProperty("java.vm.vendor")).append("\n");
            s.append("LWJGL: ").append(Sys.getVersion()).append("\n");
            s.append("OpenGL: ").append(GL11.glGetString((int)7937)).append(" version ").append(GL11.glGetString((int)7938)).append(", ").append(GL11.glGetString((int)7936)).append("\n\n");
        }
        catch (Throwable throwable) {
            s.append("[failed to get system properties (").append(throwable).append(")]\n\n");
        }
        s.append(TextFormatting.RED).append(e);
        for (StackTraceElement traceElement : trace = e.getStackTrace()) {
            s.append("\n    at ").append(traceElement);
        }
        s.append(TextFormatting.WHITE);
        GuiBlank gui = new GuiBlank();
        mc.displayGuiScreen(gui);
        GuiPopup popup = new PopupBuilder(gui, 860 / scale).withLabel("gui.exception.label.fatal_error").withMessageBox("gui.exception.list", 400 / scale, s.toString(), 860 / scale / mc.fontRenderer.getCharWidth('m')).withButtonGroup("gui.exception.choice", new String[]{"gui.exception.button.copy_error", "gui.exception.button.copy_error_and_quit"}, new int[]{0, 2}, new boolean[]{false, true}).withBackgroundColor(-12574688, -11530224).withOnCloseListener(new PopupListener(mc, s.toString().replaceAll("\u00a7[0-9a-f|klmnor]", ""))).build();
        return popup;
    }

    public static GuiPopup createStartupError(Throwable e, Minecraft mc) {
        StackTraceElement[] trace;
        int scale = Math.max(mc.resolution.scale, 1);
        StringBuilder s = new StringBuilder("An error has prevented Minecraft from starting up correctly!\n\n");
        s.append("The game cannot continue, please restart the game.\n\n");
        s.append("If you wish to report this, please copy this entire text and post it on the forum thread at ").append(TextFormatting.LIGHT_BLUE).append("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/3106066-better-than-adventure-for-beta-1-7-3-timely").append(TextFormatting.WHITE).append(", or join the Discord server at ").append(TextFormatting.LIGHT_BLUE).append("https://betterthanadventure.net/discord").append(TextFormatting.WHITE).append(" and post it in ").append(TextFormatting.LIGHT_BLUE).append("#bug-reports").append(TextFormatting.WHITE).append(".\n\n");
        try {
            s.append(TextFormatting.WHITE).append("Generated ").append(new SimpleDateFormat().format(new Date())).append("\n\n");
            s.append("Minecraft: Better than Adventure! ").append(Minecraft.VERSION).append("\n");
            s.append("OS: ").append(System.getProperty("os.name")).append(" (").append(System.getProperty("os.arch")).append(") version ").append(System.getProperty("os.version")).append("\n");
            s.append("Java: ").append(System.getProperty("java.version")).append(", ").append(System.getProperty("java.vendor")).append("\n");
            s.append("VM: ").append(System.getProperty("java.vm.name")).append(" (").append(System.getProperty("java.vm.info")).append("), ").append(System.getProperty("java.vm.vendor")).append("\n");
            s.append("LWJGL: ").append(Sys.getVersion()).append("\n");
            s.append("OpenGL: ").append(GL11.glGetString((int)7937)).append(" version ").append(GL11.glGetString((int)7938)).append(", ").append(GL11.glGetString((int)7936)).append("\n\n");
        }
        catch (Throwable throwable) {
            s.append("[failed to get system properties (").append(throwable).append(")]\n\n");
        }
        s.append(TextFormatting.RED).append(e);
        for (StackTraceElement traceElement : trace = e.getStackTrace()) {
            s.append("\n    at ").append(traceElement);
        }
        s.append(TextFormatting.WHITE);
        GuiBlank gui = new GuiBlank();
        mc.displayGuiScreen(gui);
        GuiPopup popup = new PopupBuilder(gui, 860 / scale).withLabel("gui.exception.label.startup_error").withMessageBox("gui.exception.list", 400 / scale, s.toString(), 860 / scale / mc.fontRenderer.getCharWidth('m')).withButtonGroup("gui.exception.choice", new String[]{"gui.exception.button.copy_error", "gui.exception.button.copy_error_and_quit"}, new int[]{0, 2}, new boolean[]{false, true}).withBackgroundColor(-12574688, -11530224).withOnCloseListener(new PopupListener(mc, s.toString().replaceAll("\u00a7[0-9a-f|klmnor]", ""))).build();
        return popup;
    }

    private static class PopupListener
    implements PopupCloseListener {
        private final Minecraft mc;
        private final String message;

        private PopupListener(Minecraft mc, String message) {
            this.mc = mc;
            this.message = message;
        }

        @Override
        public void onClosed(int statusCode, Map<String, ?> results) {
            switch (statusCode) {
                case 0: {
                    this.mc.hasCrashed = false;
                    break;
                }
                case 1: {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.message), null);
                    this.mc.hasCrashed = false;
                    break;
                }
                case 2: {
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.message), null);
                    this.mc.shutdownMinecraftApplet();
                }
            }
        }
    }
}

