/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Color;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiScreen
extends Gui {
    protected Minecraft mc;
    public int width;
    public int height;
    public List<GuiButton> controlList = new ArrayList<GuiButton>();
    public boolean allowIngameInput = false;
    protected FontRenderer fontRenderer;
    protected GuiButton selectedButton = null;
    final GuiScreen parentScreen;

    public GuiScreen(GuiScreen parent) {
        this.parentScreen = parent;
    }

    public GuiScreen() {
        this(null);
    }

    public GuiScreen getParentScreen() {
        return this.parentScreen;
    }

    public <E extends GuiButton> E add(E button) {
        this.controlList.add(button);
        return button;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        for (int i = 0; i < this.controlList.size(); ++i) {
            GuiButton guibutton = this.controlList.get(i);
            guibutton.drawButton(this.mc, mouseX, mouseY);
        }
    }

    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key == 14) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
        if (key == 1) {
            this.mc.displayGuiScreen(null);
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (GuiButton guiButton : this.controlList) {
                if (!guiButton.mouseClicked(this.mc, mouseX, mouseY) || !guiButton.playSound) continue;
                this.selectedButton = guiButton;
                this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                if (guiButton.listener != null) {
                    guiButton.listener.listen(guiButton);
                } else {
                    this.buttonPressed(guiButton);
                }
                return;
            }
        }
    }

    public void mouseMovedOrButtonReleased(int mouseX, int mouseY, int mouseButton) {
        if (this.selectedButton != null && mouseButton == 0) {
            this.buttonReleased(this.selectedButton);
            this.selectedButton.mouseReleased(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    protected void buttonPressed(GuiButton button) {
    }

    protected void buttonReleased(GuiButton button) {
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        this.mc = mc;
        this.fontRenderer = mc.fontRenderer;
        this.width = width;
        this.height = height;
        this.controlList.clear();
        this.init();
    }

    public void init() {
    }

    public void handleInput() {
        int mouseX = Mouse.getEventX() * this.width / this.mc.resolution.width;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.resolution.height - 1;
        while (Mouse.next() && this.mc.inputType != InputType.CONTROLLER) {
            if (Mouse.getEventButtonState()) {
                this.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                continue;
            }
            this.mouseMovedOrButtonReleased(mouseX, mouseY, Mouse.getEventButton());
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState() && ((Boolean)this.mc.gameSettings.showFrameTimes.value).booleanValue() && DebugRender.keyPressed(Keyboard.getEventKey())) continue;
            int eventKey = Keyboard.getEventKey();
            char eventChar = Keyboard.getEventCharacter();
            if (eventKey == 0 && Character.isDefined(eventChar)) {
                this.keyTyped(eventChar, eventKey, mouseX, mouseY);
                return;
            }
            if (!Keyboard.getEventKeyState()) continue;
            if (eventKey == 87) {
                this.mc.gameWindow.toggleFullscreen();
                return;
            }
            this.keyTyped(eventChar, eventKey, mouseX, mouseY);
        }
    }

    public void tick() {
    }

    public void onClosed() {
    }

    public void drawDefaultBackground() {
        this.drawWorldBackground();
    }

    public void drawWorldBackground() {
        if (this.mc.theWorld != null) {
            int color = ((Color)this.mc.gameSettings.guiBackgroundColor.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
        } else {
            this.drawBackground();
        }
    }

    public void drawBackground() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        Tessellator tessellator = Tessellator.instance;
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/assets/minecraft/textures/gui/background.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0x404040);
        tessellator.addVertexWithUV(0.0, this.height, 0.0, 0.0, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, this.height, 0.0, (float)this.width / f, (float)this.height / f);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / f, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
    }

    public void drawControllerCursor() {
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/assets/minecraft/textures/gui/gui.png"));
        this.drawTexturedModalRect(this.mc.controllerInput.cursorX - 8.0, this.mc.controllerInput.cursorY - 8.0, 224, 0, 16, 16, 32, 32);
        GL11.glDisable((int)3042);
    }

    public void controllerInput(ControllerInput controller) {
        this.guiSpecificControllerInput(controller);
        this.playControllerButtonSound(controller);
    }

    public void playControllerButtonSound(ControllerInput controller) {
        if (controller.buttonA.pressedThisFrame() || controller.buttonX.pressedThisFrame() || controller.buttonY.pressedThisFrame()) {
            this.mc.sndManager.playSound("random.ui_click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
        if (controller.buttonB.pressedThisFrame()) {
            this.mc.sndManager.playSound("random.ui_back", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
        }
    }

    public void guiSpecificControllerInput(ControllerInput controller) {
    }

    public boolean pausesGame() {
        return true;
    }

    public void selectNextField() {
    }

    public void refreshFontRenderer() {
        this.fontRenderer = this.mc.fontRenderer;
    }
}

