/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.hud.Layout;
import net.minecraft.client.gui.hud.MovableHudComponent;
import org.lwjgl.opengl.GL11;

public class ArmorBarComponent
extends MovableHudComponent {
    public ArmorBarComponent(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.playerController.canHurtPlayer() && mc.gameSettings.immersiveMode.drawHotbar() && mc.thePlayer.getPlayerProtectionAmount() > 0;
    }

    @Override
    public void render(Minecraft mc, GuiIngame gui, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
        GL11.glDisable((int)3042);
        int armorValue = mc.thePlayer.getPlayerProtectionAmount();
        for (int i = 0; i < 10; ++i) {
            if (armorValue <= 0) continue;
            int xArmor = x + this.getXSize(mc) - i * 8 - 9;
            if (i * 2 + 1 < armorValue) {
                gui.drawTexturedModalRect(xArmor, y, 34, 9, 9, 9);
            }
            if (i * 2 + 1 == armorValue) {
                gui.drawTexturedModalRect(xArmor, y, 25, 9, 9, 9);
            }
            if (i * 2 + 1 <= armorValue) continue;
            gui.drawTexturedModalRect(xArmor, y, 16, 9, 9, 9);
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
        GL11.glDisable((int)3042);
        int armorValue = 11;
        for (int i = 0; i < 10; ++i) {
            int xArmor = x + this.getXSize(mc) - i * 8 - 9;
            if (i * 2 + 1 < armorValue) {
                gui.drawTexturedModalRect(xArmor, y, 34, 9, 9, 9);
            }
            if (i * 2 + 1 == armorValue) {
                gui.drawTexturedModalRect(xArmor, y, 25, 9, 9, 9);
            }
            if (i * 2 + 1 <= armorValue) continue;
            gui.drawTexturedModalRect(xArmor, y, 16, 9, 9, 9);
        }
    }
}

