/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.b100.utils.ReflectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.gui.hud.HudComponents;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.option.BooleanOption;
import net.minecraft.client.option.ColorOption;
import net.minecraft.client.option.EnumOption;
import net.minecraft.client.option.FloatOption;
import net.minecraft.client.option.ImmersiveModeOption;
import net.minecraft.client.option.IntegerOption;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.Option;
import net.minecraft.client.option.RangeOption;
import net.minecraft.client.option.StringOption;
import net.minecraft.client.option.VolumeOption;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.Difficulty;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TooltipStyle;
import net.minecraft.client.render.window.GameWindowLWJGL2;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.ITranslatable;
import org.lwjgl.opengl.Display;

public class GameSettings {
    private static final String[] ANIMATIONS = new String[]{"options.animations.off", "options.animations.procedural", "options.animations.custom"};
    public final Minecraft mc;
    private File optionsFile;
    public IntegerOption windowWidth = new IntegerOption(this, "windowWidth", 854);
    public IntegerOption windowHeight = new IntegerOption(this, "windowHeight", 480);
    public VolumeOption masterVolume = new VolumeOption(this, "sound.master", 1.0f, SoundCategory.GUI_SOUNDS);
    public VolumeOption musicVolume = new VolumeOption(this, "sound.music", 1.0f, SoundCategory.MUSIC);
    public VolumeOption worldSoundsVolume = new VolumeOption(this, "sound.world", 1.0f, SoundCategory.WORLD_SOUNDS);
    public VolumeOption entitySoundsVolume = new VolumeOption(this, "sound.entity", 1.0f, SoundCategory.ENTITY_SOUNDS);
    public VolumeOption caveSoundsVolume = new VolumeOption(this, "sound.cave", 1.0f, SoundCategory.CAVE_SOUNDS);
    public VolumeOption guiSoundsVolume = new VolumeOption(this, "sound.gui", 1.0f, SoundCategory.GUI_SOUNDS);
    public VolumeOption weatherSoundsVolume = new VolumeOption(this, "sound.weather", 1.0f, SoundCategory.WEATHER_SOUNDS);
    public FloatOption FoV = new FloatOption(this, "fov", 0.40140846f);
    public FloatOption mouseSensitivity = new FloatOption(this, "mouseSensitivity", 0.5f);
    public FloatOption screenPadding = new FloatOption(this, "screenPadding", 0.0f);
    public FloatOption gamma = new FloatOption(this, "gamma", 0.5f);
    public FloatOption brightness = new FloatOption(this, "brightness", 0.5f);
    public FloatOption fxaa = new FloatOption(this, "fxaa", 0.0f);
    public FloatOption controllerSensitivity = new FloatOption(this, "controllerSensitivity", 0.5f);
    public FloatOption controllerMenuSensitivity = new FloatOption(this, "controllerMenuSensitivity", 0.5f);
    public FloatOption controllerDeadzoneLeft = new FloatOption(this, "controllerDeadzoneL", 0.25f);
    public FloatOption controllerDeadzoneRight = new FloatOption(this, "controllerDeadzoneR", 0.25f);
    public FloatOption blockOutlineWidth = new FloatOption(this, "blockOutlineWidth", 0.25f);
    public FloatOption flightSpeed = new FloatOption(this, "flightSpeed", 0.5f);
    public FloatOption flightSmoothness = new FloatOption(this, "flightSmoothness", 0.5f);
    public BooleanOption invertMouse = new BooleanOption(this, "invertYMouse", false);
    public BooleanOption rawMouseInput = new BooleanOption(this, "rawMouseInput", false);
    public BooleanOption viewBobbing = new BooleanOption(this, "bobView", true);
    public BooleanOption advancedOpenGL = new BooleanOption(this, "advancedOpengl", false);
    public RangeOption fancyGraphics = new RangeOption(this, "fancyGraphics", 1, 2);
    public BooleanOption treeShadows = new BooleanOption(this, "treeShadows", true);
    public BooleanOption ambientOcclusion = new BooleanOption(this, "ambientOcclusion", true);
    public BooleanOption items3D = new BooleanOption(this, "3Ditems", false);
    public BooleanOption smoothCamera = new BooleanOption(this, "smoothCamera", false);
    public BooleanOption lockCamera = new BooleanOption(this, "lockCamera", false);
    public BooleanOption biomeWater = new BooleanOption(this, "biomeWater", true);
    public BooleanOption vignette = new BooleanOption(this, "vignette", true);
    public BooleanOption showPlayerList = new BooleanOption(this, "showPlayerList", false);
    public BooleanOption slimeParticles = new BooleanOption(this, "slimeParticles", true);
    public BooleanOption disableShaders = new BooleanOption(this, "disableShaders", false);
    public StringOption shaderOverride = new StringOption(this, "shaderOverride", "");
    public BooleanOption autoHit = new BooleanOption(this, "autoHit", true);
    public BooleanOption foodHealthRegenOverlay = new BooleanOption(this, "foodHealthRegenOverlay", true);
    public BooleanOption fpsInOverlay = new BooleanOption(this, "fpsInOverlay", false);
    public BooleanOption versionInOverlay = new BooleanOption(this, "versionInOverlay", false);
    public BooleanOption controllerSwapShoulderButtons = new BooleanOption(this, "controllerSwapShoulderButtons", false);
    public BooleanOption controllerSwapAB = new BooleanOption(this, "controllerSwapAB", false);
    public BooleanOption controllerSwapXY = new BooleanOption(this, "controllerSwapXY", false);
    public BooleanOption clouds = new BooleanOption(this, "clouds", true);
    public FloatOption cloudHeight = new FloatOption(this, "cloudHeight", 0.0f);
    public BooleanOption armorDurabilityOverlay = new BooleanOption(this, "armorDurabilityOverlay", false);
    public BooleanOption armorProtectionOverlay = new BooleanOption(this, "armorProtectionOverlay", true);
    public BooleanOption heldItemCountOverlay = new BooleanOption(this, "heldItemCountOverlay", false);
    public BooleanOption pauseOnLostFocus = new BooleanOption(this, "pauseOnLostFocus", true);
    public BooleanOption showDebugScreen = new BooleanOption(this, "showDebugScreen", false);
    public BooleanOption showFrameTimes = new BooleanOption(this, "showFrameTimes", false);
    public BooleanOption showItemDebugInfo = new BooleanOption(this, "showItemDebugInfo", false);
    public BooleanOption showChunkBorders = new BooleanOption(this, "showChunkBorders", false);
    public BooleanOption showCollisionBoxes = new BooleanOption(this, "showCollisionBoxes", false);
    public BooleanOption swapCraftingButtons = new BooleanOption(this, "swapCraftingButtons", false);
    public BooleanOption disableJInput = new BooleanOption(this, "disableJInput", false);
    public BooleanOption forceUnicodeFont = new BooleanOption(this, "forceUnicodeFont", false);
    public EnumOption<PlacementMode> placementMode = new EnumOption<PlacementMode>(this, "placementMode", PlacementMode.class, PlacementMode.DEFAULT).setIsSlider(false);
    public BooleanOption discordRichPresence = new BooleanOption(this, "discordRichPresence", false);
    public ImmersiveModeOption immersiveMode = new ImmersiveModeOption(this);
    public ColorOption guiBackgroundColor = new ColorOption(this, "guiBackgroundColor", new Color().setARGB(-1072689136));
    public EnumOption<Difficulty> difficulty = new EnumOption<Difficulty>(this, "difficulty", Difficulty.class, Difficulty.NORMAL);
    public IntegerOption thirdPersonView = new IntegerOption(this, "thirdPersonView", 0);
    public EnumOption<RenderDistance> renderDistance = new EnumOption<RenderDistance>(this, "renderDistance", RenderDistance.class, RenderDistance.FAR);
    public BooleanOption enableVsync = new BooleanOption(this, "enableVsync", false);
    public RangeOption customFpsLimit = new RangeOption(this, "customFpsLimit", 0, 241);
    public IntegerOption guiScale = new IntegerOption(this, "guiScale", 0);
    public IntegerOption overlayMode = new IntegerOption(this, "overlayMode", 0);
    public IntegerOption rotationOverlayMode = new IntegerOption(this, "rotationOverlayMode", 0);
    public RangeOption animations = new RangeOption(this, "animations", 2, 3);
    public BooleanOption customAnimations = new BooleanOption(this, "customAnimations", true);
    public IntegerOption playerListPosition = new IntegerOption(this, "playerListPosition", 2);
    public BooleanOption heldItemTooltips = new BooleanOption(this, "heldItemTooltips", true);
    public FloatOption colorCorrection = new FloatOption(this, "colorCorrection", 0.5f);
    public BooleanOption sneakToggle = new BooleanOption(this, "sneakToggle", false);
    public FloatOption autosaveTimer = new FloatOption(this, "autosaveTimer", 0.041666668f);
    public BooleanOption disableResize = new BooleanOption(this, "disableResize", false);
    public BooleanOption enableItemDragging = new BooleanOption(this, "enableItemDragging", true);
    public RangeOption bloom = new RangeOption(this, "bloom", 0, 3);
    public EnumOption<RenderScale> renderScale = new EnumOption<RenderScale>(this, "renderScale", RenderScale.class, RenderScale.SCALE_100);
    public BooleanOption heatHaze = new BooleanOption(this, "heatHaze", false);
    public BooleanOption alphaMenu = new BooleanOption(this, "old", false);
    public BooleanOption enableItemClumping = new BooleanOption(this, "enableItemClumping", false);
    public BooleanOption alwaysShowDescriptions = new BooleanOption(this, "alwaysShowDescriptions", false);
    public BooleanOption turnWithVehicle = new BooleanOption(this, "turnWithVehicle", true);
    public BooleanOption disableCrashHandler = new BooleanOption(this, "disableCrashHandler", false);
    public BooleanOption downloadSoundfiles = new BooleanOption(this, "downloadSoundfiles", true);
    public BooleanOption allowSoundOverrides = new BooleanOption(this, "allowSoundOverrides", false);
    public BooleanOption loadAllSounds = new BooleanOption(this, "loadAllSounds", false);
    public BooleanOption overlayShowCoords = new BooleanOption(this, "overlayShowCoords", true);
    public BooleanOption overlayShowDirection = new BooleanOption(this, "overlayShowDirection", true);
    public BooleanOption overlayShowTime = new BooleanOption(this, "overlayShowTime", true);
    public BooleanOption overlayShowSeason = new BooleanOption(this, "overlayShowSeason", true);
    public BooleanOption overlayShowWeather = new BooleanOption(this, "overlayShowWeather", true);
    public BooleanOption overlayShowBiome = new BooleanOption(this, "overlayShowBiome", true);
    public BooleanOption[] overlayElements = new BooleanOption[]{this.overlayShowCoords, this.overlayShowDirection, this.overlayShowTime, this.overlayShowSeason, this.overlayShowWeather, this.overlayShowBiome};
    public StringOption lastServer = new StringOption(this, "lastServer", "");
    public StringOption skin = new StringOption(this, "skin", "Default");
    public StringOption selectedController = new StringOption(this, "selectedController", "");
    public StringOption language = new StringOption(this, "language", "en_US");
    public RangeOption mipmapLevels = new RangeOption(this, "mipmapLevels", 0, 5);
    public EnumOption<MipmapType> mipmapType = new EnumOption<MipmapType>(this, "mipmapType", MipmapType.class, MipmapType.SMOOTH);
    public BooleanOption fullscreen = new BooleanOption(this, "fullscreen", false);
    public BooleanOption borderlessFullscreen = new BooleanOption(this, "borderlessFullscreen", true);
    public BooleanOption startInFullscreen = new BooleanOption(this, "startInFullscreen", true);
    public BooleanOption osxFullscreenModeAPI = new BooleanOption(this, "osxFullscreenModeAPI", true);
    public EnumOption<TooltipStyle> tooltipStyle = new EnumOption<TooltipStyle>(this, "tooltipStyle", TooltipStyle.class);
    public EnumOption<LightmapStyle> lightmapStyle = new EnumOption<LightmapStyle>(this, "lightmapStyle", LightmapStyle.class, LightmapStyle.GRAY);
    public BooleanOption customLightmap = new BooleanOption(this, "customLightmap", true);
    public BooleanOption fog = new BooleanOption(this, "fog", true);
    public BooleanOption hideUndiscoveredItems = new BooleanOption(this, "hideUndiscoveredItems", true);
    public BooleanOption muteOnLostFocus = new BooleanOption(this, "muteOnLostFocus", false);
    public BooleanOption aurora = new BooleanOption(this, "aurora", true);
    public BooleanOption mobVariants = new BooleanOption(this, "mobVariants", true);
    public EnumOption<Colorblindness> colorblindnessFix = new EnumOption<Colorblindness>(this, "colorblindnessFix", Colorblindness.class, Colorblindness.NONE);
    public KeyBinding keyAttack = new KeyBinding("key.attack").setDefault(InputDevice.mouse, 0);
    public KeyBinding keyInteract = new KeyBinding("key.interact").setDefault(InputDevice.mouse, 1);
    public KeyBinding keyPickBlock = new KeyBinding("key.pickBlock").setDefault(InputDevice.mouse, 2);
    public KeyBinding keySortInventory = new KeyBinding("key.sortInventory").setDefault(InputDevice.mouse, 2);
    public KeyBinding keyForward = new KeyBinding("key.forward").setDefault(InputDevice.keyboard, 17);
    public KeyBinding keyLeft = new KeyBinding("key.left").setDefault(InputDevice.keyboard, 30);
    public KeyBinding keyBack = new KeyBinding("key.back").setDefault(InputDevice.keyboard, 31);
    public KeyBinding keyRight = new KeyBinding("key.right").setDefault(InputDevice.keyboard, 32);
    public KeyBinding keyJump = new KeyBinding("key.jump").setDefault(InputDevice.keyboard, 57);
    public KeyBinding keyInventory = new KeyBinding("key.inventory").setDefault(InputDevice.keyboard, 18);
    public KeyBinding keyDrop = new KeyBinding("key.drop").setDefault(InputDevice.keyboard, 16);
    public KeyBinding keyChat = new KeyBinding("key.chat").setDefault(InputDevice.keyboard, 20);
    public KeyBinding keyCommand = new KeyBinding("key.command").setDefault(InputDevice.keyboard, 53);
    public KeyBinding keyToggleFog = new KeyBinding("key.fog").setDefault(InputDevice.keyboard, 33);
    public KeyBinding keyToggleGamma = new KeyBinding("key.gamma").setDefault(InputDevice.keyboard, 34);
    public KeyBinding keySneak = new KeyBinding("key.sneak").setDefault(InputDevice.keyboard, 42);
    public KeyBinding keyFly = new KeyBinding("key.fly").setDefault(InputDevice.keyboard, 29);
    public KeyBinding keyGuidebook = new KeyBinding("key.guidebook").setDefault(InputDevice.keyboard, 19);
    public KeyBinding keyShowRecipe = new KeyBinding("key.showRecipe").setDefault(InputDevice.keyboard, 19);
    public KeyBinding keyShowUsage = new KeyBinding("key.showUsage").setDefault(InputDevice.keyboard, 22);
    public KeyBinding keyHotBarLeft = new KeyBinding("key.hotbar.left").setDefault(InputDevice.keyboard, 51);
    public KeyBinding keyHotBarRight = new KeyBinding("key.hotbar.right").setDefault(InputDevice.keyboard, 52);
    public KeyBinding keyHotBarSwitch = new KeyBinding("key.hotbar.switch").setDefault(InputDevice.keyboard, 15);
    public KeyBinding keyHotBarSlot1 = new KeyBinding("key.hotbar.1").setDefault(InputDevice.keyboard, 2);
    public KeyBinding keyHotBarSlot2 = new KeyBinding("key.hotbar.2").setDefault(InputDevice.keyboard, 3);
    public KeyBinding keyHotBarSlot3 = new KeyBinding("key.hotbar.3").setDefault(InputDevice.keyboard, 4);
    public KeyBinding keyHotBarSlot4 = new KeyBinding("key.hotbar.4").setDefault(InputDevice.keyboard, 5);
    public KeyBinding keyHotBarSlot5 = new KeyBinding("key.hotbar.5").setDefault(InputDevice.keyboard, 6);
    public KeyBinding keyHotBarSlot6 = new KeyBinding("key.hotbar.6").setDefault(InputDevice.keyboard, 7);
    public KeyBinding keyHotBarSlot7 = new KeyBinding("key.hotbar.7").setDefault(InputDevice.keyboard, 8);
    public KeyBinding keyHotBarSlot8 = new KeyBinding("key.hotbar.8").setDefault(InputDevice.keyboard, 9);
    public KeyBinding keyHotBarSlot9 = new KeyBinding("key.hotbar.9").setDefault(InputDevice.keyboard, 10);
    public KeyBinding keyLookLeft = new KeyBinding("key.look.left").setDefault(InputDevice.keyboard, 203);
    public KeyBinding keyLookRight = new KeyBinding("key.look.right").setDefault(InputDevice.keyboard, 205);
    public KeyBinding keyLookUp = new KeyBinding("key.look.up").setDefault(InputDevice.keyboard, 200);
    public KeyBinding keyLookDown = new KeyBinding("key.look.down").setDefault(InputDevice.keyboard, 208);
    public KeyBinding keyCenterView = new KeyBinding("key.look.center").setDefault(InputDevice.keyboard, 207);
    public KeyBinding keyZoom = new KeyBinding("key.zoom").setDefault(InputDevice.keyboard, 46);
    public KeyBinding keyPlayerList = new KeyBinding("key.playerList").setDefault(InputDevice.keyboard, 38);
    public KeyBinding keyPhotoMode = new KeyBinding("key.photoMode").setDefault(InputDevice.keyboard, 25);
    public KeyBinding keyLockRotation = new KeyBinding("key.lockRotation").setDefault(InputDevice.keyboard, 44);
    public KeyBinding keyScreenshot = new KeyBinding("key.screenshot").setDefault(InputDevice.keyboard, 60);
    public KeyBinding keyCinematicCamera = new KeyBinding("key.cinematicCamera").setDefault(InputDevice.keyboard, 66);
    public KeyBinding keySwitchPerspective = new KeyBinding("key.switchPerspective").setDefault(InputDevice.keyboard, 63);
    public KeyBinding keyHideGui = new KeyBinding("key.immersiveMode").setDefault(InputDevice.keyboard, 59);
    public KeyBinding keyAutoWalk = new KeyBinding("key.autoWalk");
    public KeyBinding keySprint = new KeyBinding("key.sprint");
    public KeyBinding keyToggleOverlay = new KeyBinding("key.toggleOverlay").setDefault(InputDevice.keyboard, 62);
    public List<KeyBinding> debugsKeys = new ArrayList<KeyBinding>();
    public KeyBinding keyToggleDebug = new KeyBinding("key.toggleDebug").setDefault(InputDevice.keyboard, 61);
    public KeyBinding keyReload = new KeyBinding("key.debug.reload").setDefault(InputDevice.keyboard, 19);
    public KeyBinding keySwitchGamemode = new KeyBinding("key.debug.gamemode").setDefault(InputDevice.keyboard, 49);
    public KeyBinding keyDumpTextures = new KeyBinding("key.debug.dumptextures").setDefault(InputDevice.keyboard, 32);
    public KeyBinding keyFullbright = new KeyBinding("key.debug.fullbright").setDefault(InputDevice.keyboard, 33);
    public KeyBinding keyLightmaps = new KeyBinding("key.debug.lightmap").setDefault(InputDevice.keyboard, 38);
    public KeyBinding keyCollisionBoxes = new KeyBinding("key.debug.collision").setDefault(InputDevice.keyboard, 48);
    public KeyBinding keyChunkBorders = new KeyBinding("key.debug.chunkborders").setDefault(InputDevice.keyboard, 34);
    public KeyBinding keyClearChat = new KeyBinding("key.debug.clearchat").setDefault(InputDevice.keyboard, 46);
    public KeyBinding keyPauseLostFocus = new KeyBinding("key.debug.pauseFocus").setDefault(InputDevice.keyboard, 25);
    public KeyBinding keyToggleItemInfo = new KeyBinding("key.debug.iteminfo").setDefault(InputDevice.keyboard, 35);
    public KeyBinding keyReloadChunks = new KeyBinding("key.debug.reloadchunks").setDefault(InputDevice.keyboard, 30);
    public KeyBinding keySmoothLighting = new KeyBinding("key.debug.smoothlighting").setDefault(InputDevice.keyboard, 31);
    public KeyBinding keyReleaseCursor = new KeyBinding("key.debug.releasecursor").setDefault(InputDevice.keyboard, 88);
    public KeyBinding keyShowShortcuts = new KeyBinding("key.debug.shortcuts").setDefault(InputDevice.keyboard, 16);
    public KeyBinding keyToggleTextureAtlas = new KeyBinding("key.debug.textureAtlas");
    public KeyBinding[] keys = ReflectUtils.getAllObjects(GameSettings.class, KeyBinding.class, this);

    public Option<?>[] getAllOptions() {
        return ReflectUtils.getAllObjects(GameSettings.class, Option.class, this);
    }

    public KeyBinding getKey(int i) {
        return this.keys[i];
    }

    public String getKeyBindName(int id) {
        return I18n.getInstance().translateKey(this.getKey(id).getId());
    }

    public GameSettings(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.optionsFile = new File(file, "options.txt");
        this.loadOptions();
        this.saveOptions();
        this.debugsKeys.add(this.keyShowShortcuts);
        this.debugsKeys.add(this.keyReload);
        this.debugsKeys.add(this.keySwitchGamemode);
        this.debugsKeys.add(this.keyDumpTextures);
        this.debugsKeys.add(this.keyFullbright);
        this.debugsKeys.add(this.keyLightmaps);
        this.debugsKeys.add(this.keyCollisionBoxes);
        this.debugsKeys.add(this.keyChunkBorders);
        this.debugsKeys.add(this.keyClearChat);
        this.debugsKeys.add(this.keyPauseLostFocus);
        this.debugsKeys.add(this.keyToggleItemInfo);
        this.debugsKeys.add(this.keyReloadChunks);
        this.debugsKeys.add(this.keySmoothLighting);
    }

    public String getDisplayString(Option<?> option) {
        if (option == null) {
            return "";
        }
        I18n trans = I18n.getInstance();
        if (option == this.borderlessFullscreen && !this.mc.gameWindow.isBorderlessFullscreenSupported()) {
            return trans.translateKey("options.borderlessFullscreen.unavailable");
        }
        if (option instanceof FloatOption) {
            FloatOption floatOption = (FloatOption)option;
            float value = ((Float)floatOption.value).floatValue();
            if (option == this.brightness) {
                int percent = (int)(value * 200.0f);
                if (percent == 0) {
                    return trans.translateKey("options.brightness.min");
                }
                if (percent == 100) {
                    return trans.translateKey("options.brightness.default");
                }
                if (percent == 200) {
                    return trans.translateKey("options.brightness.max");
                }
                return percent + "%";
            }
            if (option == this.mouseSensitivity) {
                if (value == 0.0f) {
                    return trans.translateKey("options.mouseSensitivity.min");
                }
                if (value == 1.0f) {
                    return trans.translateKey("options.mouseSensitivity.max");
                }
                return (int)(value * 200.0f) + "%";
            }
            if (option == this.FoV) {
                if (value == 0.0f) {
                    return trans.translateKey("options.fov.min");
                }
                if (value == 1.0f) {
                    return trans.translateKey("options.fov.max");
                }
                return (int)(value * 100.0f + 30.0f) + "\u00b0";
            }
            if (option == this.screenPadding) {
                int percent = (int)(value * 100.0f);
                return percent + "%";
            }
            if (option == this.gamma) {
                int percent = (int)(value * 200.0f);
                return percent + "%";
            }
            if (option == this.autosaveTimer) {
                int timer = (int)(value * 24.0f);
                if (timer == 0) {
                    return trans.translateKey("options.autosaveTimer.off");
                }
                return timer * 5 + " seconds";
            }
            if (option == this.cloudHeight) {
                int percent = (int)(value * 100.0f + 100.0f);
                if (percent == 100) {
                    return trans.translateKey("options.cloudHeight.default");
                }
                return percent + "%";
            }
            if (value == 0.0f) {
                return trans.translateKey("options.off");
            }
            return (int)(value * 100.0f) + "%";
        }
        if (option == this.guiScale) {
            if ((Integer)this.guiScale.value == 0) {
                return trans.translateKey("options.guiScale.auto");
            }
            return this.guiScale.value + "x";
        }
        if (option == this.customFpsLimit) {
            int value = (Integer)this.customFpsLimit.value;
            int maxValue = 240;
            if (((Boolean)this.enableVsync.value).booleanValue() && this.mc.gameWindow instanceof GameWindowLWJGL2) {
                return String.valueOf(((GameWindowLWJGL2)this.mc.gameWindow).defaultDisplayMode.getFrequency());
            }
            if (value > maxValue) {
                this.customFpsLimit.set(maxValue);
            }
            if (value < 15) {
                this.customFpsLimit.set(0);
                return trans.translateKey("options.customFpsLimit.unlimited");
            }
        }
        if (option == this.animations) {
            return trans.translateKey(ANIMATIONS[(Integer)this.animations.value]);
        }
        if (option == this.fancyGraphics) {
            if ((Integer)this.fancyGraphics.value == 1) {
                return trans.translateKey("options.graphics.fancy");
            }
            return trans.translateKey("options.graphics.fast");
        }
        if (option == this.lightmapStyle) {
            return trans.translateKey(((LightmapStyle)((Object)this.lightmapStyle.value)).getTranslationKey());
        }
        if (option == this.bloom) {
            if ((Integer)this.bloom.value == 0) {
                return trans.translateKey("options.off");
            }
            if ((Integer)this.bloom.value == 1) {
                return trans.translateKey("options.bloom.low");
            }
            if ((Integer)this.bloom.value == 2) {
                return trans.translateKey("options.bloom.high");
            }
        }
        if (option instanceof BooleanOption) {
            Boolean flag = (Boolean)option.value;
            if (flag.booleanValue()) {
                return trans.translateKey("options.on");
            }
            return trans.translateKey("options.off");
        }
        if (option instanceof EnumOption) {
            String key;
            EnumOption enumOption = (EnumOption)option;
            if (enumOption.value instanceof ITranslatable) {
                ITranslatable translatable = (ITranslatable)enumOption.value;
                key = translatable.getTranslationKey();
            } else {
                key = ((Enum)enumOption.value).toString().toLowerCase();
            }
            return trans.translateKey("options." + enumOption.name + "." + key);
        }
        return option.value.toString();
    }

    public void optionChanged(Option<?> option) {
        int max;
        if (option == this.enableVsync) {
            Display.setVSyncEnabled((boolean)((Boolean)this.enableVsync.value));
        }
        if (option == this.fancyGraphics) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.ambientOcclusion) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.advancedOpenGL) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.biomeWater) {
            this.mc.renderGlobal.loadRenderers();
            this.mc.renderEngine.updateDynamicTextures();
        }
        if (option == this.treeShadows) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.placementMode && this.mc.thePlayer != null) {
            this.mc.thePlayer.syncPlacementMode();
        }
        if (option == this.animations || option == this.customAnimations) {
            this.mc.renderEngine.refreshTexturesAndDisplayErrors();
            this.mc.renderEngine.updateDynamicTextures();
        }
        if (option == this.fullscreen || option == this.borderlessFullscreen) {
            this.mc.gameWindow.updateWindowState();
        }
        if (option == this.guiScale) {
            max = this.mc.resolution.getMaxScale();
            this.guiScale.value = ((Integer)this.guiScale.value + max) % max;
            this.mc.resolution.update();
            if (this.mc.currentScreen != null) {
                this.mc.currentScreen.setWorldAndResolution(this.mc, this.mc.resolution.scaledWidth, this.mc.resolution.scaledHeight);
            }
        }
        if (option == this.mipmapType || option == this.mipmapLevels) {
            this.mc.renderEngine.refreshTexturesAndDisplayErrors();
        }
        if (option == this.autosaveTimer) {
            max = 24;
            this.autosaveTimer.value = Float.valueOf((((Float)this.autosaveTimer.value).floatValue() + (float)max) % (float)max);
        }
        if (option == this.discordRichPresence && ((Boolean)this.discordRichPresence.value).booleanValue() && this.mc.rpcThread == null) {
            this.mc.rpcThread = new RichPresenceHandlerThread(this.mc);
            this.mc.rpcThread.start();
        }
        if (option == this.language && this.mc.currentScreen != null) {
            this.mc.currentScreen.setWorldAndResolution(this.mc, this.mc.resolution.scaledWidth, this.mc.resolution.scaledHeight);
        }
        if (option == this.lightmapStyle && this.mc.renderGlobal != null) {
            this.mc.renderGlobal.loadRenderers();
        }
        if (option == this.customLightmap) {
            this.mc.worldRenderer.lightmapHelper.setup();
        }
    }

    public void loadOptions() {
        HudComponents.DEFAULT_LAYOUT = HudComponents.INSTANCE.toSettingsString();
        if (!this.optionsFile.exists()) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.optionsFile));
            String line = "";
            block4: while ((line = br.readLine()) != null) {
                try {
                    int i = line.indexOf(58);
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1);
                    if (key.equals("hudLayout")) {
                        HudComponents.INSTANCE.fromSettingsString(value);
                        continue;
                    }
                    for (Option<?> option : this.getAllOptions()) {
                        if (!option.name.equalsIgnoreCase(key)) continue;
                        option.parse(value);
                        continue block4;
                    }
                    for (KeyBinding keyBinding : this.keys) {
                        if (!key.equals("key_" + keyBinding.getId())) continue;
                        keyBinding.fromOptionsString(value);
                        continue block4;
                    }
                }
                catch (Exception e) {
                    System.out.println("Skipping bad option: " + line);
                }
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("Failed to load options");
            e.printStackTrace();
        }
    }

    public void saveOptions() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.optionsFile));
            for (Option<?> option : this.getAllOptions()) {
                printwriter.println(option.name + ":" + option.getValueString());
            }
            for (KeyBinding key : this.keys) {
                printwriter.println("key_" + key.getId() + ":" + key.toOptionsString());
            }
            String hudComponentsString = HudComponents.INSTANCE.toSettingsString();
            if (hudComponentsString != null) {
                printwriter.println("hudLayout:" + hudComponentsString);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            System.out.println("Failed to save options");
            exception.printStackTrace();
        }
    }
}

