/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tool.ItemTool;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemToolHoe
extends ItemTool {
    public ItemToolHoe(String name, int id, ToolMaterial enumtoolmaterial) {
        super(name, id, 3, enumtoolmaterial, BlockTags.MINEABLE_BY_HOE);
        this.maxStackSize = 1;
        this.setMaxDamage(enumtoolmaterial.getDurability());
    }

    @Override
    public boolean canHarvestBlock(EntityLiving entityLiving, ItemStack itemStack, Block block) {
        return block.hasTag(BlockTags.MINEABLE_BY_HOE);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int id = world.getBlockId(blockX, blockY, blockZ);
        int j1 = world.getBlockId(blockX, blockY + 1, blockZ);
        if (side != Side.BOTTOM && j1 == 0 && (id == Block.grass.id || id == Block.dirt.id || id == Block.pathDirt.id || id == Block.grassRetro.id || id == Block.mud.id)) {
            int meta = 0;
            if (id == Block.mud.id) {
                meta = 1;
            }
            Block block = Block.farmlandDirt;
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.dirt, EnumBlockSoundEffectType.MINE);
            if (!(world.isClientSide || id != Block.grass.id && id != Block.grassRetro.id && id != Block.grassScorched.id || world.rand.nextInt(5) != 0)) {
                world.dropItem(blockX, blockY + 1, blockZ, new ItemStack(Item.seedsWheat));
            }
            if (world.isClientSide) {
                return true;
            }
            world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, block.id, meta);
            itemstack.damageItem(1, entityplayer);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockDestroyed(World world, ItemStack itemstack, int id, int x, int y, int z, Side side, EntityLiving entity) {
        if (!(entity == null || entity.world.isClientSide || id != Block.tallgrass.id && id != Block.tallgrassFern.id)) {
            if (this.material.isSilkTouch()) {
                entity.world.dropItem(x, y, z, new ItemStack(Item.itemsList[id]));
                itemstack.damageItem(1, entity);
            } else if (entity.world.rand.nextInt(4) == 0) {
                entity.world.dropItem(x, y, z, new ItemStack(Item.seedsWheat));
                itemstack.damageItem(1, entity);
            }
        }
        return super.onBlockDestroyed(world, itemstack, id, x, y, z, side, entity);
    }
}

